/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.Render;
import ratpack.groovy.templating.internal.TemplateCompiler;
import ratpack.groovy.templating.internal.TemplateSource;

public class GroovyTemplateRenderingEngine {
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final TemplateCompiler templateCompiler;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;
    private final ExecControl execControl;

    @Inject
    public GroovyTemplateRenderingEngine(ExecControl execControl, ByteBufAllocator byteBufAllocator, FileSystemBinding templateDir, boolean reloadable, boolean staticCompile) {
        this.execControl = execControl;
        this.reloadable = reloadable;
        this.templateDir = templateDir;
        ScriptEngine<DefaultTemplateScript> scriptEngine = new ScriptEngine<DefaultTemplateScript>(this.getClass().getClassLoader(), staticCompile, DefaultTemplateScript.class);
        this.templateCompiler = new TemplateCompiler(scriptEngine, byteBufAllocator);
        this.compiledTemplateCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TemplateSource, CompiledTemplate>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CompiledTemplate load(TemplateSource templateSource) throws Exception {
                ByteBuf content = templateSource.getContent();
                try {
                    CompiledTemplate compiledTemplate = GroovyTemplateRenderingEngine.this.templateCompiler.compile(content, templateSource.getName());
                    return compiledTemplate;
                }
                finally {
                    content.release();
                }
            }
        });
    }

    public Promise<ByteBuf> renderTemplate(ByteBuf byteBuf, String templateId, Map<String, ?> model) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        return this.render(byteBuf, this.toTemplateSource(templateId, templateFile), model);
    }

    private TemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new TemplateSource(id, templateFile, templateId);
    }

    private Promise<ByteBuf> render(ByteBuf byteBuf, TemplateSource templateSource, Map<String, ?> model) throws Exception {
        return Render.render(this.execControl, byteBuf, this.compiledTemplateCache, templateSource, model, (Function<String, TemplateSource>)((Function)templateName -> this.toTemplateSource((String)templateName, this.getTemplateFile((String)templateName))));
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

