/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import ratpack.groovy.templating.TemplateModel;
import ratpack.util.Types;

public class MapBackedTemplateModel
implements TemplateModel {
    private final Map<String, Object> backing;

    public MapBackedTemplateModel(Map<String, Object> backing) {
        this.backing = backing;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.backing.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.backing.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.backing.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.backing.putAll(m);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.backing.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.backing.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.backing.entrySet();
    }

    @Override
    public <K, V> Map<K, V> map(String key, Class<K> keyType, Class<V> valueType) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        Map mapValue = (Map)value;
        return mapValue;
    }

    @Override
    public Map<String, Object> map(String key) {
        return this.map(key, String.class, Object.class);
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeToken.of(type));
    }

    @Override
    public <T> T get(String key, TypeToken<T> type) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (type.getRawType().isInstance(value)) {
            return (T)Types.cast((Object)value);
        }
        throw new IllegalArgumentException(String.format("Template model object with key '%s' is of type '%s', not requested '%s' (toString: %s)", key, value.getClass().getName(), type, value));
    }
}

