/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.func.Function;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.util.ExceptionUtils;

public class Render {
    private final ExecControl execControl;
    private final ByteBuf byteBuf;
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final TemplateSource templateSource;
    private final Map<String, ?> model;
    private final Function<String, TemplateSource> includeTransformer;

    public Render(ExecControl execControl, ByteBuf byteBuf, LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache, TemplateSource templateSource, Map<String, ?> model, Function<String, TemplateSource> includeTransformer) {
        this.execControl = execControl;
        this.byteBuf = byteBuf;
        this.compiledTemplateCache = compiledTemplateCache;
        this.templateSource = templateSource;
        this.model = model;
        this.includeTransformer = includeTransformer;
    }

    private Promise<ByteBuf> invoke() {
        return this.execControl.promise(f -> {
            try {
                CompiledTemplate fromCache = this.getFromCache(this.compiledTemplateCache, this.templateSource);
                this.execute(fromCache, this.model, this.byteBuf);
                f.success((Object)this.byteBuf);
            }
            catch (Throwable e) {
                f.error(e);
            }
        });
    }

    private CompiledTemplate getFromCache(LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache, TemplateSource templateSource) {
        try {
            return (CompiledTemplate)compiledTemplateCache.get((Object)templateSource);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck((Throwable)ExceptionUtils.toException((Throwable)e.getCause()));
        }
    }

    private void executeNested(String templatePath, Map<String, ?> model, ByteBuf buffer) throws Exception {
        TemplateSource templateSource = (TemplateSource)this.includeTransformer.apply((Object)templatePath);
        CompiledTemplate compiledTemplate = this.getFromCache(this.compiledTemplateCache, templateSource);
        this.execute(compiledTemplate, model, buffer);
    }

    private void execute(CompiledTemplate compiledTemplate, Map<String, ?> model, ByteBuf parts) throws Exception {
        compiledTemplate.execute(model, parts, (String templatePath, Map<String, ?> nestedModel) -> {
            HashMap modelCopy = new HashMap(model);
            modelCopy.putAll(nestedModel);
            this.executeNested(templatePath, modelCopy, parts);
        });
    }

    public static Promise<ByteBuf> render(ExecControl execControl, ByteBuf byteBuf, LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache, TemplateSource templateSource, Map<String, ?> model, Function<String, TemplateSource> includeTransformer) throws Exception {
        return new Render(execControl, byteBuf, compiledTemplateCache, templateSource, model, includeTransformer).invoke();
    }
}

