/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.InvalidTemplateException;
import ratpack.groovy.templating.internal.TemplateParser;

public class TemplateCompiler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ByteBufAllocator byteBufAllocator;
    private boolean verbose;
    private final TemplateParser parser = new TemplateParser();
    private final ScriptEngine<DefaultTemplateScript> scriptEngine;

    public TemplateCompiler(ScriptEngine<DefaultTemplateScript> scriptEngine, ByteBufAllocator byteBufAllocator) {
        this(scriptEngine, false, byteBufAllocator);
    }

    public TemplateCompiler(ScriptEngine<DefaultTemplateScript> scriptEngine, boolean verbose, ByteBufAllocator byteBufAllocator) {
        this.scriptEngine = scriptEngine;
        this.verbose = verbose;
        this.byteBufAllocator = byteBufAllocator;
    }

    public CompiledTemplate compile(ByteBuf templateSource, String name) throws CompilationFailedException, IOException {
        ByteBuf scriptSource = this.byteBufAllocator.buffer(templateSource.capacity());
        this.parser.parse(templateSource, scriptSource);
        String scriptSourceString = scriptSource.toString(CharsetUtil.UTF_8);
        scriptSource.release();
        if (this.verbose && this.logger.isInfoEnabled()) {
            this.logger.info("\n-- script source --\n" + scriptSourceString + "\n-- script end --\n");
        }
        try {
            Class<DefaultTemplateScript> scriptClass = this.scriptEngine.compile(name, scriptSourceString);
            return new CompiledTemplate(name, scriptClass);
        }
        catch (Exception e) {
            throw new InvalidTemplateException(name, "compilation failure", e);
        }
    }
}

