/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.xml.MarkupBuilder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Map;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.groovy.guice.GroovyBindingsSpec;
import ratpack.groovy.handling.GroovyChain;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.ClosureBackedHandler;
import ratpack.groovy.handling.internal.DefaultGroovyChain;
import ratpack.groovy.handling.internal.DefaultGroovyContext;
import ratpack.groovy.handling.internal.GroovyDslChainActionTransformer;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.RatpackScriptBacking;
import ratpack.groovy.template.Markup;
import ratpack.groovy.template.MarkupTemplate;
import ratpack.groovy.template.TextTemplate;
import ratpack.handling.Chain;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainBuilders;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;

public abstract class Groovy {
    private Groovy() {
    }

    public static void ratpack(@DelegatesTo(value=Ratpack.class, strategy=1) Closure<?> closure) {
        try {
            RatpackScriptBacking.execute(closure);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
    }

    public static Handler chain(LaunchConfig launchConfig, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain(launchConfig, null, closure);
    }

    public static GroovyContext context(Context context) {
        return context instanceof GroovyContext ? (GroovyContext)context : new DefaultGroovyContext(context);
    }

    public static Handler chain(LaunchConfig launchConfig, Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return ChainBuilders.build((launchConfig != null && launchConfig.isDevelopment() ? 1 : 0) != 0, (Function)new GroovyDslChainActionTransformer(launchConfig, registry), new ClosureInvoker(closure).toAction(registry, 1));
    }

    public static Action<Chain> chainAction(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return chain -> ClosureUtil.configureDelegateFirst(new DefaultGroovyChain((Chain)chain), closure);
    }

    public static TextTemplate groovyTemplate(String id) {
        return Groovy.groovyTemplate(id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id) {
        return Groovy.groovyMarkupTemplate(id, (String)null);
    }

    public static TextTemplate groovyTemplate(String id, String type) {
        return Groovy.groovyTemplate(ImmutableMap.of(), id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type) {
        return Groovy.groovyMarkupTemplate(ImmutableMap.of(), id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyMarkupTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) throws Exception {
        return Groovy.groovyMarkupTemplate(id, null, modelBuilder);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) throws Exception {
        ImmutableMap model = ((ImmutableMap.Builder)Action.with((Object)ImmutableMap.builder(), (Action)Action.noopIfNull(modelBuilder))).build();
        return Groovy.groovyMarkupTemplate(model, id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id, String type) {
        return new TextTemplate(model, id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id, String type) {
        return new MarkupTemplate(id, type, model);
    }

    public static Handler groovyHandler(@DelegatesTo(value=GroovyContext.class, strategy=1) Closure<?> closure) {
        return new ClosureBackedHandler(closure);
    }

    public static void chain(Chain chain, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        GroovyChain groovyChain = chain instanceof GroovyChain ? (GroovyChain)chain : new DefaultGroovyChain(chain);
        new ClosureInvoker(closure).invoke(chain.getRegistry(), groovyChain, 1);
    }

    public static Action<Chain> chain(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return c -> Groovy.chain(c, closure);
    }

    public static Markup htmlBuilder(@DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return Groovy.markupBuilder(HttpHeaderConstants.HTML_UTF_8, CharsetUtil.UTF_8, closure);
    }

    public static Markup markupBuilder(CharSequence contentType, CharSequence encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, Charset.forName(encoding.toString()), closure);
    }

    public static Markup markupBuilder(CharSequence contentType, Charset encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, encoding, closure);
    }

    public static interface Ratpack {
        public void bindings(@DelegatesTo(value=GroovyBindingsSpec.class, strategy=1) Closure<?> var1);

        public void handlers(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> var1);
    }
}

