/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import groovy.lang.Closure;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.groovy.Groovy;
import ratpack.groovy.guice.internal.DefaultGroovyBindingsSpec;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.InjectorHandlerTransformer;
import ratpack.guice.BindingsSpec;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.handling.Handler;
import ratpack.launch.LaunchConfig;

public class RatpackDslClosureToHandlerTransformer
implements Function<Closure<?>, Handler> {
    private final LaunchConfig launchConfig;
    private final GuiceBackedHandlerFactory handlerFactory;
    private final Function<? super Module, ? extends Injector> moduleTransformer;

    public RatpackDslClosureToHandlerTransformer(LaunchConfig launchConfig, GuiceBackedHandlerFactory handlerFactory, Function<? super Module, ? extends Injector> moduleTransformer) {
        this.launchConfig = launchConfig;
        this.handlerFactory = handlerFactory;
        this.moduleTransformer = moduleTransformer;
    }

    public Handler apply(Closure<?> closure) throws Exception {
        RatpackImpl ratpack = new RatpackImpl();
        ClosureUtil.configureDelegateFirst(ratpack, closure);
        final Closure bindingsConfigurer = ratpack.bindingsConfigurer;
        Closure handlersConfigurer = ratpack.handlersConfigurer;
        Action<BindingsSpec> bindingsAction = new Action<BindingsSpec>(){

            public void execute(BindingsSpec thing) throws Exception {
                ClosureUtil.delegatingAction(bindingsConfigurer).execute((Object)new DefaultGroovyBindingsSpec(thing));
            }
        };
        return this.handlerFactory.create((Action)bindingsAction, this.moduleTransformer, (Function)new InjectorHandlerTransformer(this.launchConfig, handlersConfigurer));
    }

    static class RatpackImpl
    implements Groovy.Ratpack {
        private Closure<?> bindingsConfigurer;
        private Closure<?> handlersConfigurer;

        RatpackImpl() {
        }

        @Override
        public void bindings(Closure<?> bindingsConfigurer) {
            this.bindingsConfigurer = bindingsConfigurer;
        }

        @Override
        public void handlers(Closure<?> handlersConfigurer) {
            this.handlersConfigurer = handlersConfigurer;
        }
    }
}

