/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.nio.file.Path;
import java.util.function.Supplier;
import ratpack.func.Action;
import ratpack.func.BiFunction;
import ratpack.func.Function;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.RatpackScriptBacking;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.util.ExceptionUtils;

public class RatpackDslCapture<T extends Groovy.Ratpack, V>
implements BiFunction<Path, String, V> {
    private final Supplier<T> dslBackingFactory;
    private final boolean compileStatic;
    private final Function<? super T, ? extends V> valueFunction;

    public RatpackDslCapture(boolean compileStatic, Supplier<T> dslBackingFactory, Function<? super T, ? extends V> valueFunction) {
        this.dslBackingFactory = dslBackingFactory;
        this.compileStatic = compileStatic;
        this.valueFunction = valueFunction;
    }

    public V apply(Path file, String script) throws Exception {
        ClassLoader classLoader = RatpackDslCapture.class.getClassLoader();
        ScriptEngine<Script> scriptEngine = new ScriptEngine<Script>(classLoader, this.compileStatic, Script.class);
        ClosureCaptureAction backing = new ClosureCaptureAction();
        RatpackScriptBacking.withBacking(backing, () -> ExceptionUtils.uncheck(() -> scriptEngine.create(file.getFileName().toString(), file, script, new Object[0]).run()));
        Groovy.Ratpack dslBacking = (Groovy.Ratpack)this.dslBackingFactory.get();
        Closure closure = backing.closure;
        ClosureUtil.configureDelegateFirst(dslBacking, closure);
        return (V)this.valueFunction.apply((Object)dslBacking);
    }

    private static class ClosureCaptureAction
    implements Action<Closure<?>> {
        private Closure<?> closure;

        private ClosureCaptureAction() {
        }

        public void execute(Closure<?> configurer) throws Exception {
            this.closure = configurer;
        }
    }
}

