/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.template.internal.CompiledTextTemplate;
import ratpack.groovy.template.internal.DefaultTextTemplateScript;
import ratpack.groovy.template.internal.Render;
import ratpack.groovy.template.internal.TextTemplateCompiler;
import ratpack.groovy.template.internal.TextTemplateSource;

public class TextTemplateRenderingEngine {
    private final LoadingCache<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache;
    private final TextTemplateCompiler templateCompiler;
    private final ByteBufAllocator byteBufAllocator;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;
    private final ExecControl execControl;

    @Inject
    public TextTemplateRenderingEngine(ExecControl execControl, ByteBufAllocator byteBufAllocator, FileSystemBinding templateDir, boolean reloadable, boolean staticCompile) {
        this.execControl = execControl;
        this.byteBufAllocator = byteBufAllocator;
        this.reloadable = reloadable;
        this.templateDir = templateDir;
        ScriptEngine<DefaultTextTemplateScript> scriptEngine = new ScriptEngine<DefaultTextTemplateScript>(this.getClass().getClassLoader(), staticCompile, DefaultTextTemplateScript.class);
        this.templateCompiler = new TextTemplateCompiler(scriptEngine, byteBufAllocator);
        this.compiledTemplateCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TextTemplateSource, CompiledTextTemplate>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CompiledTextTemplate load(TextTemplateSource templateSource) throws Exception {
                ByteBuf content = templateSource.getContent();
                try {
                    CompiledTextTemplate compiledTextTemplate = TextTemplateRenderingEngine.this.templateCompiler.compile(content, templateSource.getName());
                    return compiledTextTemplate;
                }
                finally {
                    content.release();
                }
            }
        });
    }

    public Promise<ByteBuf> renderTemplate(String templateId, Map<String, ?> model) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        return this.render(this.toTemplateSource(templateId, templateFile), model);
    }

    private TextTemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new TextTemplateSource(this.byteBufAllocator, id, templateFile, templateId);
    }

    private Promise<ByteBuf> render(TextTemplateSource templateSource, Map<String, ?> model) throws Exception {
        return Render.render(this.execControl, this.byteBufAllocator, this.compiledTemplateCache, templateSource, model, (Function<String, TextTemplateSource>)((Function)templateName -> this.toTemplateSource((String)templateName, this.getTemplateFile((String)templateName))));
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

