/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.guice.Guice;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.util.Exceptions;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private static final AtomicReference<Action<? super RatpackServer>> CAPTURE_ACTION = new AtomicReference<Object>(null);
    private final ThreadLocal<RatpackServer> running = new ThreadLocal();

    public static void captureNext(Action<? super RatpackServer> action) {
        CAPTURE_ACTION.set(action);
    }

    public void execute(Closure<?> closure) throws Exception {
        RatpackServer ratpackServer;
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        Optional.ofNullable(this.running.get()).ifPresent(s -> Exceptions.uncheck(() -> ((RatpackServer)s).stop()));
        Path scriptFile = ClosureUtil.findScript(closure);
        if (scriptFile == null) {
            ratpackServer = RatpackServer.of(server -> ClosureUtil.configureDelegateFirst(new RatpackBacking((RatpackServerSpec)server), closure));
        } else {
            ratpackServer = RatpackServer.of(Groovy.Script.app(scriptFile));
            Action action = CAPTURE_ACTION.getAndSet(null);
            if (action != null) {
                action.execute((Object)ratpackServer);
            }
        }
        ratpackServer.start();
        this.running.set(ratpackServer);
    }

    private static class RatpackBacking
    implements Groovy.Ratpack {
        private final RatpackServerSpec server;

        public RatpackBacking(RatpackServerSpec server) {
            this.server = server;
        }

        @Override
        public void bindings(Closure<?> configurer) {
            this.server.registry(Guice.registry(ClosureUtil.delegatingAction(configurer)));
        }

        @Override
        public void handlers(Closure<?> configurer) {
            Exceptions.uncheck(() -> this.server.handlers(Groovy.chainAction(configurer)));
        }

        @Override
        public void serverConfig(Closure<?> configurer) {
            ServerConfigBuilder builder = ServerConfig.builder().development(true);
            ClosureUtil.configureDelegateFirst(builder, configurer);
            this.server.serverConfig(builder);
        }
    }
}

