/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal.capture;

import groovy.lang.Closure;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.groovy.internal.StandaloneScriptBacking;

public abstract class RatpackScriptBacking {
    private static final ThreadLocal<Action<Closure<?>>> BACKING_HOLDER = new InheritableThreadLocal<Action<Closure<?>>>(){

        @Override
        protected Action<Closure<?>> initialValue() {
            return new StandaloneScriptBacking();
        }
    };

    public static void withBacking(Action<Closure<?>> backing, Block runnable) throws Exception {
        Action<Closure<?>> previousBacking = BACKING_HOLDER.get();
        BACKING_HOLDER.set(backing);
        try {
            runnable.execute();
        }
        finally {
            BACKING_HOLDER.set(previousBacking);
        }
    }

    public static void execute(Closure<?> closure) throws Exception {
        BACKING_HOLDER.get().execute(closure);
    }
}

