/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import ratpack.exec.Promise;
import ratpack.func.Function;
import ratpack.groovy.template.internal.CompiledTextTemplate;
import ratpack.groovy.template.internal.TextTemplateSource;
import ratpack.util.Exceptions;

public class Render {
    private final ByteBufAllocator bufferAllocator;
    private final LoadingCache<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache;
    private final TextTemplateSource templateSource;
    private final Map<String, ?> model;
    private final Function<String, TextTemplateSource> includeTransformer;

    private Render(ByteBufAllocator bufferAllocator, LoadingCache<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource, Map<String, ?> model, Function<String, TextTemplateSource> includeTransformer) {
        this.bufferAllocator = bufferAllocator;
        this.compiledTemplateCache = compiledTemplateCache;
        this.templateSource = templateSource;
        this.model = model;
        this.includeTransformer = includeTransformer;
    }

    private Promise<ByteBuf> invoke() {
        return Promise.of(f -> {
            ByteBuf byteBuf = this.bufferAllocator.ioBuffer();
            try {
                CompiledTextTemplate fromCache = this.getFromCache(this.compiledTemplateCache, this.templateSource);
                this.execute(fromCache, this.model, byteBuf);
                f.success((Object)byteBuf);
            }
            catch (Throwable e) {
                byteBuf.release();
                f.error(e);
            }
        });
    }

    private CompiledTextTemplate getFromCache(LoadingCache<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource) {
        try {
            return (CompiledTextTemplate)compiledTemplateCache.get((Object)templateSource);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Exceptions.uncheck((Throwable)Exceptions.toException((Throwable)e.getCause()));
        }
    }

    private void executeNested(String templatePath, Map<String, ?> model, ByteBuf buffer) throws Exception {
        TextTemplateSource templateSource = (TextTemplateSource)this.includeTransformer.apply((Object)templatePath);
        CompiledTextTemplate compiledTemplate = this.getFromCache(this.compiledTemplateCache, templateSource);
        this.execute(compiledTemplate, model, buffer);
    }

    private void execute(CompiledTextTemplate compiledTemplate, Map<String, ?> model, ByteBuf parts) throws Exception {
        compiledTemplate.execute(model, parts, (String templatePath, Map<String, ?> nestedModel) -> {
            HashMap modelCopy = new HashMap(model);
            modelCopy.putAll(nestedModel);
            this.executeNested(templatePath, modelCopy, parts);
        });
    }

    public static Promise<ByteBuf> render(ByteBufAllocator bufferAllocator, LoadingCache<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource, Map<String, ?> model, Function<String, TextTemplateSource> includeTransformer) throws Exception {
        return new Render(bufferAllocator, compiledTemplateCache, templateSource, model, includeTransformer).invoke();
    }
}

