/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hikari;

import com.zaxxer.hikari.pool.HikariPool;
import java.sql.SQLException;
import java.time.Duration;
import ratpack.exec.Blocking;
import ratpack.exec.Promise;
import ratpack.health.HealthCheck;
import ratpack.registry.Registry;

public abstract class HikariHealthCheck
implements HealthCheck {
    public String getName() {
        return "hikari";
    }

    public Duration getTimeout() {
        return Duration.ofSeconds(5L);
    }

    public abstract HikariPool getHikariPool();

    public Promise<HealthCheck.Result> check(Registry registry) {
        return Blocking.get(() -> {
            try {
                this.getHikariPool().getConnection(this.getTimeout().toMillis()).close();
                return HealthCheck.Result.healthy();
            }
            catch (SQLException e) {
                return HealthCheck.Result.unhealthy((String)String.format("Hikari couldn't get a connection after %ss", this.getTimeout().getSeconds()), (Throwable)e);
            }
        });
    }
}

