/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.handling.Handler;
import ratpack.session.SessionCookieConfig;
import ratpack.session.SessionIdGenerator;
import ratpack.session.SessionManager;
import ratpack.session.internal.DefaultSessionCookieConfig;
import ratpack.session.internal.DefaultSessionIdGenerator;
import ratpack.session.internal.DefaultSessionManager;
import ratpack.session.internal.SessionBindingHandler;

public class SessionModule
extends AbstractModule
implements HandlerDecoratingModule {
    private int cookieExpiresMins = 31536000;
    private String cookieDomain;
    private String cookiePath = "/";

    public int getCookieExpiresMins() {
        return this.cookieExpiresMins;
    }

    public void setCookieExpiresMins(int cookieExpiresMins) {
        this.cookieExpiresMins = cookieExpiresMins;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    protected void configure() {
        this.bind(SessionIdGenerator.class).to(DefaultSessionIdGenerator.class).in(Singleton.class);
        this.bind(SessionManager.class).to(DefaultSessionManager.class).in(Singleton.class);
        this.bind(SessionCookieConfig.class).toInstance((Object)new DefaultSessionCookieConfig(this.cookieExpiresMins, this.cookieDomain, this.cookiePath));
    }

    public Handler decorate(Injector injector, Handler handler) {
        return new SessionBindingHandler(handler);
    }
}

