/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.core.http.Response;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.func.Types;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.Session;
import ratpack.session.SessionData;
import ratpack.session.SessionId;
import ratpack.session.SessionKey;
import ratpack.session.SessionSerializer;
import ratpack.session.SessionStore;
import ratpack.session.SessionTypeFilter;
import ratpack.session.internal.DefaultSessionKey;

public class DefaultSession
implements Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(Session.class);
    private Map<SessionKey<?>, byte[]> entries;
    private final SessionId sessionId;
    private final ByteBufAllocator bufferAllocator;
    private final SessionStore storeAdapter;
    private final Response response;
    private final SessionSerializer defaultSerializer;
    private final JavaSessionSerializer javaSerializer;
    private final SessionTypeFilter typeFilter;
    private State state = State.NOT_LOADED;
    private boolean callbackAdded;
    private final SessionData data = new Data();

    public DefaultSession(SessionId sessionId, ByteBufAllocator bufferAllocator, SessionStore storeAdapter, Response response, SessionSerializer defaultSerializer, JavaSessionSerializer javaSerializer, SessionTypeFilter typeFilter) {
        this.sessionId = sessionId;
        this.bufferAllocator = bufferAllocator;
        this.storeAdapter = storeAdapter;
        this.response = response;
        this.defaultSerializer = defaultSerializer;
        this.javaSerializer = javaSerializer;
        this.typeFilter = typeFilter;
    }

    @Override
    public String getId() {
        return this.sessionId.getValue().toString();
    }

    @Override
    public Promise<SessionData> getData() {
        if (this.state == State.NOT_LOADED) {
            return this.storeAdapter.load(this.sessionId.getValue()).map(bytes -> {
                this.state = State.CLEAN;
                try {
                    this.hydrate((ByteBuf)bytes);
                }
                finally {
                    bytes.release();
                }
                return this.data;
            });
        }
        return Promise.value((Object)this.data);
    }

    private void hydrate(ByteBuf bytes) {
        block5: {
            if (bytes.readableBytes() > 0) {
                try {
                    SerializedForm deserialized = this.defaultSerializer.deserialize(SerializedForm.class, (InputStream)new ByteBufInputStream(bytes), this.typeFilter);
                    if (deserialized == null) {
                        this.entries = new HashMap();
                        break block5;
                    }
                    this.entries = deserialized.entries;
                }
                catch (Exception e) {
                    LOGGER.warn("Exception thrown deserializing session " + this.getId() + " with serializer " + this.defaultSerializer + " (session will be discarded)", (Throwable)e);
                    this.entries = new HashMap();
                    this.markDirty();
                }
            } else {
                this.entries = new HashMap();
            }
        }
    }

    @Override
    public JavaSessionSerializer getJavaSerializer() {
        return this.javaSerializer;
    }

    @Override
    public SessionSerializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    @Override
    public boolean isDirty() {
        return this.state == State.DIRTY;
    }

    private ByteBuf serialize() throws Exception {
        SerializedForm serializable = new SerializedForm();
        serializable.entries = this.entries;
        ByteBuf buffer = this.bufferAllocator.buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        try {
            this.defaultSerializer.serialize(SerializedForm.class, serializable, (OutputStream)outputStream, this.typeFilter);
            outputStream.close();
            return buffer;
        }
        catch (Throwable e) {
            buffer.release();
            throw e;
        }
    }

    @Override
    public Operation save() {
        return Operation.of(() -> {
            if (this.state != State.NOT_LOADED) {
                if (this.entries.isEmpty()) {
                    this.storeAdapter.remove(this.sessionId.getValue()).then();
                } else {
                    ByteBuf serialized = this.serialize();
                    this.storeAdapter.store(this.sessionId.getValue(), serialized).wiretap(o -> serialized.release()).then(() -> {
                        this.state = State.CLEAN;
                    });
                }
            }
        });
    }

    @Override
    public Operation terminate() {
        return this.storeAdapter.remove(this.sessionId.getValue()).next(() -> {
            this.sessionId.terminate();
            if (this.entries != null) {
                this.entries.clear();
            }
            this.state = State.NOT_LOADED;
        });
    }

    private void markDirty() {
        this.state = State.DIRTY;
        if (!this.callbackAdded) {
            this.callbackAdded = true;
            this.response.beforeSend(responseMetaData -> {
                this.callbackAdded = false;
                if (this.state == State.DIRTY) {
                    this.save().then();
                }
            });
        }
    }

    private class Data
    implements SessionData {
        private Data() {
        }

        @Override
        public <T> Optional<T> get(SessionKey<T> key, SessionSerializer serializer) throws Exception {
            String name = key.getName();
            if (key.getType() == null && (key = (SessionKey)Types.cast(this.findKey(name))) == null) {
                return Optional.empty();
            }
            byte[] bytes = (byte[])DefaultSession.this.entries.get(key);
            if (bytes == null) {
                return Optional.empty();
            }
            try {
                Object value = serializer.deserialize(key.getType(), new ByteArrayInputStream(bytes), DefaultSession.this.typeFilter);
                return Optional.ofNullable(value);
            }
            catch (Exception e) {
                LOGGER.warn("Exception thrown deserializing entry " + key + " with serializer " + serializer + " (value will be discarded from session)", (Throwable)e);
                this.remove(key);
                return Optional.empty();
            }
        }

        private SessionKey<?> findKey(String name) {
            ImmutableList entries = FluentIterable.from(DefaultSession.this.entries.entrySet()).filter(e -> Objects.equals(((SessionKey)e.getKey()).getName(), name)).toList();
            if (entries.isEmpty()) {
                return null;
            }
            if (entries.size() == 1) {
                return (SessionKey)((Map.Entry)entries.get(0)).getKey();
            }
            throw new IllegalArgumentException("Found more than one session entry with name '" + name + "': " + Iterables.transform((Iterable)entries, Map.Entry::getKey));
        }

        @Override
        public <T> void set(SessionKey<T> key, T value, SessionSerializer serializer) throws Exception {
            Objects.requireNonNull(key, "session key cannot be null");
            Objects.requireNonNull(value, "session value for key " + key.getName() + " cannot be null");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            serializer.serialize(key.getType(), value, out, DefaultSession.this.typeFilter);
            DefaultSession.this.entries.put(key, out.toByteArray());
            DefaultSession.this.markDirty();
        }

        @Override
        public Set<SessionKey<?>> getKeys() {
            return DefaultSession.this.entries.keySet();
        }

        @Override
        public SessionSerializer getDefaultSerializer() {
            return DefaultSession.this.defaultSerializer;
        }

        @Override
        public void remove(SessionKey<?> key) {
            if (key.getType() == null && (key = this.findKey(key.getName())) == null) {
                return;
            }
            if (DefaultSession.this.entries.remove(key) != null) {
                DefaultSession.this.markDirty();
            }
        }

        @Override
        public void clear() {
            DefaultSession.this.entries.clear();
            DefaultSession.this.markDirty();
        }

        @Override
        public Session getSession() {
            return DefaultSession.this;
        }
    }

    static class SerializedForm
    implements Externalizable {
        private static final long serialVersionUID = 2L;
        private static final Ordering<SessionKey<?>> KEY_NAME_ORDERING = Ordering.natural().nullsFirst().onResultOf(SessionKey::getName);
        private static final Ordering<SessionKey<?>> KEY_TYPE_ORDERING = Ordering.natural().nullsFirst().onResultOf(k -> k.getType() == null ? null : k.getType().getName());
        private static final Comparator<SessionKey<?>> COMPARATOR = KEY_NAME_ORDERING.compound(KEY_TYPE_ORDERING);
        private Map<SessionKey<?>, byte[]> entries;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(1);
            out.writeShort(this.entries.size());
            ImmutableSortedMap sorted = ImmutableSortedMap.copyOf(this.entries, COMPARATOR);
            for (Map.Entry entry : sorted.entrySet()) {
                String name = ((SessionKey)entry.getKey()).getName();
                if (name == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(name);
                }
                Class type = ((SessionKey)entry.getKey()).getType();
                if (type == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(type.getName());
                }
                byte[] bytes = (byte[])entry.getValue();
                out.writeInt(bytes.length);
                out.write(bytes);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            in.readShort();
            short num = in.readShort();
            this.entries = new HashMap(num);
            for (short i = 0; i < num; i = (short)(i + 1)) {
                Class type;
                String name;
                String string = name = in.readBoolean() ? in.readUTF() : null;
                if (in.readBoolean()) {
                    String typeName = in.readUTF();
                    Class<?> o = classLoader.loadClass(typeName);
                    type = (Class)Types.cast(o);
                } else {
                    type = null;
                }
                int bytesLength = in.readInt();
                byte[] bytes = new byte[bytesLength];
                for (int read = in.read(bytes); read < bytesLength; read += in.read(bytes, read, bytesLength - read)) {
                }
                this.entries.put(new DefaultSessionKey(name, type), bytes);
            }
        }
    }

    private static enum State {
        NOT_LOADED,
        CLEAN,
        DIRTY;

    }
}

