/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.session.SessionSerializer;

public class InsecureSessionSerializerWarning {
    public static final Logger LOGGER = LoggerFactory.getLogger(InsecureSessionSerializerWarning.class);

    private InsecureSessionSerializerWarning() {
    }

    public static void log(Class<? extends SessionSerializer> implType) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(implType.getName() + " does not implement type filtering, which makes your application vulnerable if session data can be provided by untrusted sources (see https://portswigger.net/web-security/deserialization). Please contact the author of " + implType.getName() + " and urge them to update it to support type filtering.");
        }
    }
}

