/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol;

import io.remotecontrol.util.ClassLoaderConfigurableObjectInputStream;
import io.remotecontrol.util.UnexpectedIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SerializationUtil {
    public static byte[] serialize(Serializable serializable) throws NotSerializableException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SerializationUtil.serialize(serializable, baos);
        }
        catch (IOException e) {
            if (e instanceof NotSerializableException) {
                throw (NotSerializableException)e;
            }
            throw new UnexpectedIOException("Unexpected exception while serializing object: " + serializable, e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        try {
            oos.writeObject(serializable);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static <T> T deserialize(Class<T> type, byte[] bytes, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return SerializationUtil.deserialize(type, new ByteArrayInputStream(bytes), classLoader);
        }
        catch (IOException e) {
            throw new UnexpectedIOException("Unexpected exception while deserializing in memory", e);
        }
    }

    public static <T> T deserialize(Class<T> type, InputStream inputStream, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Object o = new ClassLoaderConfigurableObjectInputStream(classLoader, inputStream).readObject();
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        throw new IllegalArgumentException("Expecting to deserialize instance of " + type.getName() + " but got " + o.getClass().getName() + ": " + o.toString());
    }

    public static Class<?> defineClass(ClassLoader classLoader, byte[] bytes) {
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            Object clazz = defineClass.invoke((Object)classLoader, null, bytes, 0, bytes.length);
            return (Class)clazz;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

