/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.client;

import io.remotecontrol.Command;
import io.remotecontrol.CommandChain;
import io.remotecontrol.client.RemoteException;
import io.remotecontrol.client.Transport;
import io.remotecontrol.client.UnserializableResultStrategy;
import io.remotecontrol.client.UnserializableReturnException;
import io.remotecontrol.result.NullResult;
import io.remotecontrol.result.Result;
import io.remotecontrol.result.SerializedResult;
import io.remotecontrol.result.ThrownResult;
import io.remotecontrol.result.UnserializableResult;
import io.remotecontrol.result.UnserializableThrownResult;
import java.io.IOException;

public class RemoteControlSupport<T extends Command> {
    private final Transport transport;
    private final UnserializableResultStrategy unserializableResultStrategy;
    private final ClassLoader classLoader;

    public RemoteControlSupport(Transport transport, UnserializableResultStrategy unserializableResultStrategy, ClassLoader classLoader) {
        this.transport = transport;
        this.unserializableResultStrategy = unserializableResultStrategy;
        this.classLoader = classLoader;
    }

    public Object send(CommandChain<T> commandChain) throws IOException {
        Result result = this.sendCommandChain(commandChain);
        return this.processResult(result);
    }

    protected Result sendCommandChain(CommandChain commandChain) throws IOException {
        return this.transport.send(commandChain);
    }

    protected Object processResult(Result result) {
        if (result instanceof NullResult) {
            return null;
        }
        if (result instanceof ThrownResult) {
            ThrownResult thrownResult = (ThrownResult)result;
            throw new RemoteException(thrownResult.deserialize(this.classLoader));
        }
        if (result instanceof UnserializableThrownResult) {
            UnserializableThrownResult unserializedThrownResult = (UnserializableThrownResult)result;
            throw new RemoteException(unserializedThrownResult.deserializeWrapper(this.classLoader));
        }
        if (result instanceof UnserializableResult) {
            UnserializableResult unserializableResult = (UnserializableResult)result;
            if (this.unserializableResultStrategy == UnserializableResultStrategy.NULL) {
                return null;
            }
            if (this.unserializableResultStrategy == UnserializableResultStrategy.STRING) {
                return unserializableResult.getStringRepresentation();
            }
            if (this.unserializableResultStrategy == UnserializableResultStrategy.THROW) {
                throw new UnserializableReturnException(unserializableResult);
            }
            throw new IllegalStateException("Unhandled UnserializableResultStrategy: " + (Object)((Object)this.unserializableResultStrategy));
        }
        if (result instanceof SerializedResult) {
            SerializedResult serializedResult = (SerializedResult)result;
            return serializedResult.deserialize(this.classLoader);
        }
        throw new IllegalArgumentException("Unknown result type: " + result);
    }
}

