/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.groovy.client;

import groovy.lang.Closure;
import io.remotecontrol.SerializationUtil;
import io.remotecontrol.UnserializableCommandException;
import io.remotecontrol.client.CommandGenerator;
import io.remotecontrol.groovy.ClosureCommand;
import io.remotecontrol.groovy.ClosureUtil;
import io.remotecontrol.groovy.client.InnerClosureClassDefinitionsFinder;
import io.remotecontrol.groovy.client.RawClosureCommand;
import io.remotecontrol.util.UnexpectedIOException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class ClosureCommandGenerator
implements CommandGenerator<RawClosureCommand, ClosureCommand> {
    private final ClassLoader classLoader;

    public ClosureCommandGenerator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClosureCommandGenerator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<ClosureCommand> getCommandType() {
        return ClosureCommand.class;
    }

    @Override
    public ClosureCommand generate(RawClosureCommand rawClosureCommand) {
        Closure cloned = (Closure)rawClosureCommand.getRoot().clone();
        Closure root = this.getRootClosure(cloned);
        byte[] bytes = this.serializeInstance(cloned, root);
        byte[] classBytes = this.getClassBytes(root.getClass());
        LinkedList<byte[]> supports = new LinkedList<byte[]>(this.getSupportingClassesBytes(root.getClass()));
        List<Closure<?>> used = rawClosureCommand.getUsed();
        if (!used.isEmpty()) {
            for (Closure<?> usedClosure : used) {
                supports.add(this.getClassBytes(usedClosure.getClass()));
                supports.addAll(this.getSupportingClassesBytes(usedClosure.getClass()));
            }
        }
        return new ClosureCommand(bytes, classBytes, supports);
    }

    protected Closure getRootClosure(Closure closure) {
        Closure root = closure;
        while (root instanceof CurriedClosure) {
            root = (Closure)root.getOwner();
        }
        return root;
    }

    protected List<byte[]> getSupportingClassesBytes(Class<? extends Closure> closureClass) {
        try {
            return new InnerClosureClassDefinitionsFinder(this.classLoader).find(closureClass);
        }
        catch (IOException e) {
            throw new UnexpectedIOException("cannnot find inner closures of: " + closureClass.getName(), e);
        }
    }

    protected byte[] getClassBytes(Class<? extends Closure> closureClass) {
        String classFileName = this.getClassFileName(closureClass);
        URL classFileResource = this.classLoader.getResource(classFileName);
        if (classFileResource == null) {
            throw new IllegalStateException("Could not find class file for class " + String.valueOf(closureClass));
        }
        try {
            return DefaultGroovyMethods.getBytes((URL)classFileResource);
        }
        catch (IOException e) {
            throw new UnexpectedIOException("reading class files", e);
        }
    }

    protected String getClassFileName(Class closureClass) {
        return closureClass.getName().replace(".", "/") + ".class";
    }

    protected byte[] serializeInstance(Closure closure, Closure root) {
        ClosureUtil.nullFields(root);
        try {
            return SerializationUtil.serialize((Serializable)closure);
        }
        catch (NotSerializableException e) {
            throw new UnserializableCommandException((Object)("Unable to serialize closure: " + closure), e);
        }
    }
}

