/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.groovy.client;

import groovy.lang.Closure;
import io.remotecontrol.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class InnerClosureClassDefinitionsFinder {
    private final URLClassLoader classLoader;

    public InnerClosureClassDefinitionsFinder(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Only URLClassLoaders are supported");
        }
        this.classLoader = (URLClassLoader)classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> find(Class<? extends Closure> clazz) throws IOException {
        ArrayList<byte[]> classes = new ArrayList<byte[]>();
        String innerClassPrefix = this.toInnerClassPrefix(clazz);
        String packageDirPath = this.toPackageDirPath(clazz);
        String innerClassPrefixWithPackage = packageDirPath + "/" + innerClassPrefix;
        String ownerClassFileName = innerClassPrefix + ".class";
        for (URLClassLoader loader : this.calculateEffectiveClassLoaderHierarchy()) {
            for (URL url : loader.getURLs()) {
                File root;
                if (!url.getProtocol().equals("file")) continue;
                try {
                    root = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (!root.exists()) continue;
                if (root.isDirectory()) {
                    File packageDir;
                    File file = packageDir = packageDirPath != null ? new File(root, packageDirPath) : root;
                    if (!packageDir.exists()) continue;
                    for (String classFileName : packageDir.list()) {
                        if (!classFileName.startsWith(innerClassPrefix) || !classFileName.endsWith(".class") || classFileName.length() == ownerClassFileName.length()) continue;
                        File file2 = new File(packageDir, classFileName);
                        classes.add(IoUtil.read(file2));
                    }
                    continue;
                }
                if (!root.getName().endsWith(".jar") && !root.getName().endsWith(".zip")) continue;
                ZipFile jarFile = new ZipFile(root);
                try {
                    File packageDir;
                    File file = packageDir = packageDirPath == null ? root : jarFile.getEntry(packageDirPath);
                    if (packageDir == null) continue;
                    Enumeration<? extends ZipEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(innerClassPrefixWithPackage) || !name.endsWith(".class") || name.endsWith(ownerClassFileName)) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        classes.add(IoUtil.read(inputStream));
                    }
                }
                finally {
                    jarFile.close();
                }
            }
        }
        return classes;
    }

    protected List<URLClassLoader> calculateEffectiveClassLoaderHierarchy() {
        ArrayList<URLClassLoader> hierarchy = new ArrayList<URLClassLoader>();
        for (URLClassLoader current = this.classLoader; current != null && current instanceof URLClassLoader; current = (URLClassLoader)current.getParent()) {
            hierarchy.add(current);
        }
        return hierarchy;
    }

    protected String toPackageDirPath(Class clazz) {
        Package pkg = clazz.getPackage();
        return pkg == null ? "" : pkg.getName().replace(".", "/");
    }

    protected String toInnerClassPrefix(Class clazz) {
        Package var = clazz.getPackage();
        String packageName = var == null ? null : var.getName();
        String fixedName = clazz.getName().replace("$_$", "$_");
        if (packageName == null) {
            return fixedName;
        }
        return fixedName.substring(packageName.length() + 1);
    }
}

