/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.groovy.client;

import groovy.lang.Closure;
import io.remotecontrol.CommandChain;
import io.remotecontrol.client.CommandGenerator;
import io.remotecontrol.client.RemoteControlSupport;
import io.remotecontrol.client.Transport;
import io.remotecontrol.client.UnserializableResultStrategy;
import io.remotecontrol.groovy.ClosureCommand;
import io.remotecontrol.groovy.ClosureUtil;
import io.remotecontrol.groovy.client.ClosureCommandGenerator;
import io.remotecontrol.groovy.client.RawClosureCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RemoteControl {
    private final CommandGenerator<RawClosureCommand, ClosureCommand> commandGenerator;
    private final RemoteControlSupport<ClosureCommand> support;

    public RemoteControl(Transport transport) {
        this(transport, UnserializableResultStrategy.THROW, Thread.currentThread().getContextClassLoader());
    }

    public RemoteControl(Transport transport, ClassLoader classLoader) {
        this(transport, UnserializableResultStrategy.THROW, classLoader);
    }

    protected RemoteControl(Transport transport, UnserializableResultStrategy unserializableResultStrategy, ClassLoader classLoader) {
        this.support = new RemoteControlSupport(transport, unserializableResultStrategy, classLoader);
        this.commandGenerator = new ClosureCommandGenerator(classLoader);
    }

    public Object exec(Closure[] commands) throws IOException {
        return this.exec(new LinkedHashMap(), commands);
    }

    public Object exec(Map<String, ?> params, Closure[] commands) throws IOException {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(params);
        this.processExecParams(copy);
        CommandChain<ClosureCommand> commandChain = this.generateCommandChain(copy, commands);
        return this.support.send(commandChain);
    }

    public Object call(Closure[] commands) throws IOException {
        return this.exec(commands);
    }

    public Object call(Map<String, ?> params, Closure[] commands) throws IOException {
        return this.exec(params, commands);
    }

    protected void processExecParams(Map<String, Object> params) {
        for (String key : params.keySet()) {
            if (key.equals("usedClosures")) {
                Object usedClosures = params.get(key);
                if (usedClosures instanceof Iterable) {
                    for (Object usedClosure : (Iterable)usedClosures) {
                        if (usedClosure instanceof Closure) {
                            ClosureUtil.nullFields((Closure)usedClosure);
                            continue;
                        }
                        throw new IllegalArgumentException("'usedClosures' elements must be closures");
                    }
                    continue;
                }
                throw new IllegalArgumentException("'usedClosures' argument must be iterable");
            }
            throw new IllegalArgumentException("Unknown option '" + key + "'");
        }
    }

    protected CommandChain<ClosureCommand> generateCommandChain(Map<String, Object> params, Closure<?>[] closures) throws IOException {
        ArrayList<ClosureCommand> commands = new ArrayList<ClosureCommand>(closures.length);
        for (Closure<?> closure : closures) {
            List uses = Collections.emptyList();
            if (params.containsKey("usedClosures")) {
                List usedClosures;
                uses = usedClosures = (List)params.get("usedClosures");
            }
            ClosureCommand command = this.commandGenerator.generate(new RawClosureCommand(closure, uses));
            commands.add(command);
        }
        return CommandChain.of(ClosureCommand.class, commands);
    }
}

