/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.result.impl;

import io.remotecontrol.RemoteControlException;
import io.remotecontrol.SerializationUtil;
import io.remotecontrol.UnserializableExceptionException;
import io.remotecontrol.result.Result;
import io.remotecontrol.result.ResultFactory;
import io.remotecontrol.result.impl.DefaultNullResult;
import io.remotecontrol.result.impl.DefaultSerializedResult;
import io.remotecontrol.result.impl.DefaultThrownResult;
import io.remotecontrol.result.impl.DefaultUnserializableResult;
import io.remotecontrol.result.impl.DefaultUnserializableThrownResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.Serializable;

public class DefaultResultFactory
implements ResultFactory {
    @Override
    public Result forValue(Object value) {
        if (value == null) {
            return new DefaultNullResult();
        }
        if (value instanceof Serializable) {
            return this.forSerializable((Serializable)value);
        }
        return this.forUnserializable(value);
    }

    protected Result forSerializable(Serializable serializable) {
        try {
            byte[] bytes = SerializationUtil.serialize(serializable);
            return new DefaultSerializedResult(bytes);
        }
        catch (NotSerializableException e) {
            return this.forUnserializable(serializable);
        }
    }

    protected Result forUnserializable(Object unserializable) {
        return new DefaultUnserializableResult(unserializable.toString());
    }

    @Override
    public Result forThrown(Throwable throwable) {
        try {
            byte[] bytes = SerializationUtil.serialize(throwable);
            return new DefaultThrownResult(bytes);
        }
        catch (NotSerializableException e) {
            try {
                return new DefaultUnserializableThrownResult(throwable.toString(), SerializationUtil.serialize(new UnserializableExceptionException(throwable)));
            }
            catch (NotSerializableException e1) {
                throw new IllegalStateException("Can't serialize NotSerializableException", e1);
            }
        }
    }

    @Override
    public Result deserialize(InputStream inputStream, ClassLoader classLoader) throws IOException {
        try {
            return SerializationUtil.deserialize(Result.class, inputStream, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw RemoteControlException.classNotFoundOnClient(e);
        }
    }
}

