/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.server;

import io.remotecontrol.CommandChain;
import io.remotecontrol.groovy.ClosureCommand;
import io.remotecontrol.result.Result;
import io.remotecontrol.result.ResultFactory;
import io.remotecontrol.server.CommandInvoker;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class CommandChainInvoker {
    private final ClassLoader parentLoader;
    private final CommandChain<ClosureCommand> commandChain;
    private final ResultFactory resultFactory;

    public CommandChainInvoker(ClassLoader parentLoader, CommandChain<ClosureCommand> commandChain, ResultFactory resultFactory) {
        this.resultFactory = resultFactory;
        this.parentLoader = parentLoader;
        this.commandChain = commandChain;
    }

    public Result invokeAgainst(Object delegate, Object firstArg) {
        Object arg = firstArg;
        for (ClosureCommand command : this.commandChain.getCommands()) {
            CommandInvoker invoker = this.createInvoker(this.parentLoader, command);
            try {
                arg = invoker.invokeAgainst(delegate, arg);
            }
            catch (InvokerInvocationException e) {
                return this.resultFactory.forThrown(e.getCause());
            }
            catch (Throwable throwable) {
                return this.resultFactory.forThrown(throwable);
            }
        }
        return this.resultFactory.forValue(arg);
    }

    protected CommandInvoker createInvoker(ClassLoader loader, ClosureCommand command) {
        return new CommandInvoker(loader, command);
    }
}

