/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.server;

import io.remotecontrol.Command;
import io.remotecontrol.CommandChain;
import io.remotecontrol.RemoteControlException;
import io.remotecontrol.SerializationUtil;
import io.remotecontrol.result.Result;
import io.remotecontrol.server.CommandRunner;
import io.remotecontrol.server.Receiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class MultiTypeReceiver
implements Receiver {
    private final ClassLoader classLoader;
    private final List<CommandRunner<?>> runners;

    public MultiTypeReceiver(ClassLoader classLoader, CommandRunner<?> ... runners) {
        this.classLoader = classLoader;
        this.runners = Arrays.asList(runners);
    }

    @Override
    public void execute(InputStream commandStream, OutputStream resultStream) throws IOException {
        CommandChain commandChain;
        try {
            commandChain = SerializationUtil.deserialize(CommandChain.class, commandStream, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw RemoteControlException.classNotFoundOnServer(e);
        }
        for (CommandRunner<?> runner : this.runners) {
            Result result = this.maybeInvoke(commandChain, runner);
            if (result == null) continue;
            SerializationUtil.serialize(result, resultStream);
            return;
        }
        throw new RemoteControlException((Object)("Cannot handle commands of type:" + commandChain.getType().getName()));
    }

    private <T extends Command> Result maybeInvoke(CommandChain<T> commandChain, CommandRunner<?> runner) {
        if (commandChain.getType().isAssignableFrom(runner.getType())) {
            CommandRunner<?> cast = runner;
            return cast.run(commandChain);
        }
        return null;
    }
}

