/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.server;

import groovy.lang.Closure;
import io.remotecontrol.CommandChain;
import io.remotecontrol.groovy.server.ContextFactory;
import io.remotecontrol.server.Storage;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class StorageContextFactory
implements ContextFactory {
    public static StorageContextFactory withEmptyStorage() {
        return new WithEmptyStorage();
    }

    public static StorageContextFactory withSeed(Map<String, Object> seed) {
        return new WithSeed(seed);
    }

    public static StorageContextFactory withGenerator(Closure generator) {
        return new WithGenerator(generator);
    }

    private static class WithGenerator
    extends StorageContextFactory {
        private final Closure generator;

        public WithGenerator(Closure generator) {
            this.generator = generator;
        }

        public final Closure getGenerator() {
            return this.generator;
        }

        public Storage getContext(CommandChain chain) {
            LinkedHashMap storage = this.generator.call((Object)chain);
            if (storage == null) {
                storage = new LinkedHashMap();
            }
            if (storage instanceof Map) {
                Map cast = storage;
                return new Storage(cast);
            }
            throw new IllegalArgumentException("The generator did not return a map");
        }
    }

    private static class WithSeed
    extends StorageContextFactory {
        private final Map<String, Object> seed;

        public WithSeed(Map<String, Object> seed) {
            this.seed = new LinkedHashMap<String, Object>(seed);
        }

        public Storage getContext(CommandChain chain) {
            return new Storage(new LinkedHashMap<String, Object>(this.seed));
        }

        public final Map<String, Object> getSeed() {
            return this.seed;
        }
    }

    private static class WithEmptyStorage
    extends StorageContextFactory {
        private WithEmptyStorage() {
        }

        public Storage getContext(CommandChain chain) {
            return new Storage(new LinkedHashMap<String, Object>());
        }
    }
}

