/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassLoaderConfigurableObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public ClassLoaderConfigurableObjectInputStream(ClassLoader classLoader, InputStream input) throws IOException {
        super(input);
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return this.classLoader.loadClass(desc.getName());
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

