/*
 * Decompiled with CFR 0.152.
 */
package io.remotecontrol.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FilteringClassLoader
extends ClassLoader {
    private final String[] blockedPackages;

    public FilteringClassLoader(ClassLoader parent, String ... blockedPackages) {
        super(parent);
        this.blockedPackages = blockedPackages;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl;
        try {
            cl = super.loadClass(name, false);
        }
        catch (NoClassDefFoundError e) {
            if (this.classAllowed(name)) {
                throw e;
            }
            throw new ClassNotFoundException(String.format("%s not found.", name));
        }
        if (!this.allowed(cl)) {
            throw new ClassNotFoundException(String.format("%s not found.", cl.getName()));
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    @Override
    protected Package getPackage(String name) {
        Package p = super.getPackage(name);
        if (p == null || !this.allowed(p)) {
            return null;
        }
        return p;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package p : super.getPackages()) {
            if (!this.allowed(p)) continue;
            packages.add(p);
        }
        return packages.toArray(new Package[packages.size()]);
    }

    private boolean allowed(Package pkg) {
        for (String packagePrefix : this.blockedPackages) {
            if (!pkg.getName().startsWith(packagePrefix)) continue;
            return false;
        }
        return true;
    }

    private boolean allowed(Class<?> clazz) {
        return this.classAllowed(clazz.getName());
    }

    private boolean classAllowed(String className) {
        for (String packagePrefix : this.blockedPackages) {
            if (!className.startsWith(packagePrefix)) continue;
            return false;
        }
        return true;
    }

    private static class EmptyEnumeration<T>
    implements Enumeration<T> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

