/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationProvider;
import io.seata.config.FileConfiguration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String REGISTRY_CONF = "registry.conf";
    public static final Configuration FILE_INSTANCE = new FileConfiguration("registry.conf");
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";

    public static Configuration getInstance() {
        ConfigType configType = null;
        String configTypeName = null;
        try {
            configTypeName = FILE_INSTANCE.getConfig("config.type");
            configType = ConfigType.getType(configTypeName);
        }
        catch (Exception exx) {
            throw new NotSupportYetException("not support register type: " + configTypeName);
        }
        if (ConfigType.File == configType) {
            String pathDataId = "config.file.name";
            String name = FILE_INSTANCE.getConfig(pathDataId);
            return new FileConfiguration(name);
        }
        return ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)Objects.requireNonNull(configType).name())).provide();
    }
}

