/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.common;

import io.selendroid.common.device.DeviceTargetPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SelendroidCapabilities
extends DesiredCapabilities {
    private static final long serialVersionUID = -7061568919298342362L;
    private static final String SELENDROID = "selendroid";
    public static final String AUT = "aut";
    public static final String EMULATOR = "emulator";
    public static final String DISPLAY = "display";
    public static final String LOCALE = "locale";
    public static final String SCREEN_SIZE = "screenSize";
    public static final String PRE_SESSION_ADB_COMMANDS = "preSessionAdbCommands";
    public static final String SERIAL = "serial";
    public static final String MODEL = "model";
    public static final String PLATFORM_VERSION = "platformVersion";
    public static final String PLATFORM_NAME = "platformName";
    public static final String AUTOMATION_NAME = "automationName";
    public static final String LAUNCH_ACTIVITY = "launchActivity";
    public static final String SELENDROID_EXTENSIONS = "selendroidExtensions";
    public static final String BOOTSTRAP_CLASS_NAMES = "bootstrapClassNames";

    public static SelendroidCapabilities empty() {
        return new SelendroidCapabilities(new HashMap());
    }

    public static SelendroidCapabilities copyOf(SelendroidCapabilities caps) {
        return new SelendroidCapabilities(caps.getRawCapabilities());
    }

    public SelendroidCapabilities(Map<String, ?> from) {
        for (String key : from.keySet()) {
            this.setCapability(key, from.get(key));
        }
    }

    public String getSerial() {
        if (this.getRawCapabilities().get(SERIAL) == null || this.getRawCapabilities().get(SERIAL).equals(JSONObject.NULL)) {
            return null;
        }
        return (String)this.getRawCapabilities().get(SERIAL);
    }

    public String getPlatformVersion() {
        return (String)this.getRawCapabilities().get(PLATFORM_VERSION);
    }

    public String getAut() {
        return (String)this.getRawCapabilities().get(AUT);
    }

    public String getModel() {
        return (String)this.getRawCapabilities().get(MODEL);
    }

    public String getLaunchActivity() {
        return (String)this.getRawCapabilities().get(LAUNCH_ACTIVITY);
    }

    public Boolean getEmulator() {
        if (this.getRawCapabilities().get(EMULATOR) == null || this.getRawCapabilities().get(EMULATOR).equals(JSONObject.NULL)) {
            return null;
        }
        return (Boolean)this.getRawCapabilities().get(EMULATOR);
    }

    public String getPlatformName() {
        return (String)this.getRawCapabilities().get(PLATFORM_NAME);
    }

    public String getAutomationName() {
        return (String)this.getRawCapabilities().get(AUTOMATION_NAME);
    }

    public String getLocale() {
        return (String)this.getRawCapabilities().get(LOCALE);
    }

    public Map<String, Object> getRawCapabilities() {
        return this.asMap();
    }

    public String getScreenSize() {
        return (String)this.getRawCapabilities().get(SCREEN_SIZE);
    }

    public String getSelendroidExtensions() {
        return (String)this.getRawCapabilities().get(SELENDROID_EXTENSIONS);
    }

    public String getBootstrapClassNames() {
        return (String)this.getRawCapabilities().get(BOOTSTRAP_CLASS_NAMES);
    }

    public void setSerial(String serial) {
        this.setCapability(SERIAL, serial);
    }

    public void setModel(String model) {
        this.setCapability(MODEL, model);
    }

    public void setPlatformVersion(DeviceTargetPlatform androidTarget) {
        this.setCapability(PLATFORM_VERSION, androidTarget.getApi());
    }

    public void setAut(String aut) {
        this.setCapability(AUT, aut);
    }

    public void setLaunchActivity(String launchActivity) {
        this.setCapability(LAUNCH_ACTIVITY, launchActivity);
    }

    public void setEmulator(Boolean emulator) {
        this.setCapability(EMULATOR, emulator);
    }

    public void setLocale(String locale) {
        this.setCapability(LOCALE, locale);
    }

    public void setScreenSize(String screenSize) {
        this.setCapability(SCREEN_SIZE, screenSize);
    }

    public SelendroidCapabilities setSelendroidExtensions(String filePath) {
        this.setCapability(SELENDROID_EXTENSIONS, filePath);
        return this;
    }

    public SelendroidCapabilities addBootstrapClass(String className) {
        String currentClassNames = this.getBootstrapClassNames();
        if (currentClassNames == null || currentClassNames.isEmpty()) {
            this.setCapability(BOOTSTRAP_CLASS_NAMES, className);
        } else {
            this.setCapability(BOOTSTRAP_CLASS_NAMES, currentClassNames + "," + className);
        }
        return this;
    }

    public SelendroidCapabilities(JSONObject source) throws JSONException {
        Iterator iter = source.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = source.get(key);
            this.setCapability(key, this.decode(value));
        }
        if (source.has("browserName") && !source.has(AUT)) {
            this.setAut(source.getString("browserName"));
        }
    }

    public SelendroidCapabilities() {
        this.setCapability(AUTOMATION_NAME, SELENDROID);
        this.setBrowserName(SELENDROID);
        this.setCapability(PLATFORM_NAME, "android");
    }

    public SelendroidCapabilities(String aut) {
        this();
        this.setAut(aut);
    }

    public SelendroidCapabilities(String serial, String aut) {
        this(aut);
        this.setSerial(serial);
        if (serial == null) {
            this.setEmulator(null);
        } else if (serial.startsWith(EMULATOR)) {
            this.setEmulator(true);
        } else {
            this.setEmulator(false);
        }
    }

    public static SelendroidCapabilities emulator(String aut) {
        SelendroidCapabilities caps = new SelendroidCapabilities();
        caps.setAut(aut);
        caps.setEmulator(true);
        return caps;
    }

    public static SelendroidCapabilities emulator(DeviceTargetPlatform platform, String aut) {
        SelendroidCapabilities caps = new SelendroidCapabilities();
        caps.setPlatformVersion(platform);
        caps.setAut(aut);
        caps.setEmulator(true);
        return caps;
    }

    public static DesiredCapabilities android(DeviceTargetPlatform platform) {
        SelendroidCapabilities capabilities = new SelendroidCapabilities();
        capabilities.setCapability("browserName", "android");
        capabilities.setCapability("version", "");
        capabilities.setCapability("platform", "android");
        capabilities.setCapability(PLATFORM_NAME, "android");
        capabilities.setCapability(PLATFORM_VERSION, platform.getApi());
        return capabilities;
    }

    public List<String> getPreSessionAdbCommands() {
        ArrayList<String> res = new ArrayList<String>();
        Object capa = this.getCapability(PRE_SESSION_ADB_COMMANDS);
        if (capa != null) {
            res.addAll((Collection)capa);
        }
        return res;
    }

    public void setPreSessionAdbCommands(List<String> commands) {
        this.setCapability(PRE_SESSION_ADB_COMMANDS, commands);
    }

    public static SelendroidCapabilities device(DeviceTargetPlatform platform, String aut) {
        SelendroidCapabilities caps = SelendroidCapabilities.emulator(platform, aut);
        caps.setEmulator(false);
        return caps;
    }

    public static SelendroidCapabilities device(String aut) {
        SelendroidCapabilities caps = SelendroidCapabilities.emulator(aut);
        caps.setEmulator(false);
        return caps;
    }

    private Object decode(Object o) throws JSONException {
        if (o instanceof JSONArray) {
            ArrayList<Object> res = new ArrayList<Object>();
            JSONArray array = (JSONArray)o;
            for (int i = 0; i < array.length(); ++i) {
                Object r = array.get(i);
                res.add(this.decode(r));
            }
            return res;
        }
        return o;
    }

    public SelendroidCapabilities withMerged(SelendroidCapabilities caps) {
        SelendroidCapabilities copy = SelendroidCapabilities.copyOf(this);
        for (Map.Entry<String, Object> entry : caps.getRawCapabilities().entrySet()) {
            copy.setCapability(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public String getDefaultApp(Set<String> supportedApps) {
        String defaultApp = this.getAut();
        if (this.getLaunchActivity() != null) {
            return defaultApp;
        }
        if (!defaultApp.contains(":")) {
            return this.getDefaultVersion(supportedApps, defaultApp);
        }
        return supportedApps.contains(defaultApp) ? defaultApp : null;
    }

    private String getDefaultVersion(Set<String> keys, String appName) {
        TreeSet<String> listOfApps = new TreeSet<String>();
        for (String key : keys) {
            if (!key.split(":")[0].contentEquals(appName)) continue;
            listOfApps.add(key);
        }
        return listOfApps.size() > 0 ? (String)listOfApps.last() : null;
    }
}

