/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Throwables;
import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.log.LogLevelEnum;
import io.selendroid.standalone.server.SelendroidStandaloneServer;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SelendroidLauncher {
    public static final String LOGGER_NAME = "io.selendroid";
    private static final Logger log = Logger.getLogger(SelendroidLauncher.class.getName());
    private SelendroidStandaloneServer server = null;
    private SelendroidConfiguration config = null;

    public SelendroidLauncher(SelendroidConfiguration config) {
        this.config = config;
    }

    public static SelendroidConfiguration parseConfig(String[] args) {
        JCommander jCommander;
        SelendroidConfiguration config = new SelendroidConfiguration();
        try {
            jCommander = new JCommander((Object)config, args);
            jCommander.setProgramName("Selendroid Standalone Server");
        }
        catch (ParameterException e) {
            log.log(Level.SEVERE, "An error occurred while starting selendroid");
            throw Throwables.propagate((Throwable)e);
        }
        if (config.isPrintHelp()) {
            jCommander.usage();
            System.exit(0);
        }
        return config;
    }

    private void launchServer() {
        try {
            log.info("Starting Selendroid standalone on port " + this.config.getPort());
            this.server = new SelendroidStandaloneServer(this.config);
            this.server.start();
        }
        catch (AndroidSdkException e) {
            log.severe("Selendroid standalone was not able to interact with the Android SDK: " + e.getMessage());
            log.severe("Please make sure you have the latest version with the latest updates installed: ");
            log.severe("http://developer.android.com/sdk/index.html");
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            log.severe("Error building server: " + e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Shutting down Selendroid standalone");
                SelendroidLauncher.this.stopSelendroid();
            }
        });
    }

    public void launchSelendroid() {
        this.launchServer();
        if (this.config.isGrid()) {
            HttpClientUtil.waitForServer(this.config.getPort(), 3L, TimeUnit.MINUTES);
        } else {
            HttpClientUtil.waitForServer(this.config.getPort(), 20L, TimeUnit.SECONDS);
        }
    }

    public static void main(String[] args) {
        try {
            SelendroidLauncher.configureLogging();
        }
        catch (Exception e1) {
            log.severe("Error occurred while registering logging file handler.");
        }
        log.info("################# Selendroid #################");
        SelendroidConfiguration config = SelendroidLauncher.parseConfig(args);
        log.info("################# Configuration in use #################");
        log.info(config.toString());
        if (LogLevelEnum.ERROR.equals((Object)config.getLogLevel())) {
            Logger.getLogger(LOGGER_NAME).setLevel(LogLevelEnum.VERBOSE.level);
        } else {
            Logger.getLogger(LOGGER_NAME).setLevel(config.getLogLevel().level);
        }
        new SelendroidLauncher(config).launchServer();
    }

    private static void configureLogging() throws Exception {
        FileHandler fh = new FileHandler("%h/selendroid.log", 0x200000, 1);
        fh.setFormatter(new SimpleFormatter());
        Logger.getLogger(LOGGER_NAME).addHandler(fh);
    }

    public void stopSelendroid() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public SelendroidStandaloneServer getServer() {
        return this.server;
    }
}

