/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.android.impl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import io.selendroid.common.SelendroidCapabilities;
import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.server.common.model.ExternalStorageFile;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.AndroidSdk;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.ShellCommandException;
import io.selendroid.standalone.io.ShellCommand;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.logging.LogEntry;

public abstract class AbstractDevice
implements AndroidDevice {
    private static final Logger log = Logger.getLogger(AbstractDevice.class.getName());
    public static final String WD_STATUS_ENDPOINT = "http://localhost:8080/wd/hub/status";
    protected String serial = null;
    protected String model = null;
    protected Integer port = null;
    protected IDevice device;
    private ByteArrayOutputStream logoutput;
    private ExecuteWatchdog logcatWatchdog;
    private static final Integer COMMAND_TIMEOUT = 20000;
    private boolean loggingEnabled = true;

    public AbstractDevice(String serial) {
        this.serial = serial;
    }

    public AbstractDevice(IDevice device) {
        this.device = device;
        this.serial = device.getSerialNumber();
    }

    protected AbstractDevice() {
    }

    protected boolean isSerialConfigured() {
        return this.serial != null && !this.serial.isEmpty();
    }

    @Override
    public void setVerbose() {
        log.setLevel(Level.FINEST);
    }

    @Override
    public boolean isDeviceReady() {
        CommandLine command = this.adbCommand("shell", "getprop init.svc.bootanim");
        String bootAnimDisplayed = null;
        try {
            bootAnimDisplayed = ShellCommand.exec(command);
        }
        catch (ShellCommandException e) {
            log.log(Level.INFO, "Could not get property init.svc.bootanim", e);
        }
        return bootAnimDisplayed != null && bootAnimDisplayed.contains("stopped");
    }

    @Override
    public boolean isInstalled(String appBasePackage) throws AndroidSdkException {
        CommandLine command = this.adbCommand("shell", "pm", "list", "packages");
        command.addArgument(appBasePackage, false);
        String result = null;
        try {
            result = ShellCommand.exec(command);
        }
        catch (ShellCommandException e) {
            // empty catch block
        }
        return result != null && result.contains("package:" + appBasePackage);
    }

    @Override
    public boolean isInstalled(AndroidApp app) throws AndroidSdkException {
        return this.isInstalled(app.getBasePackage());
    }

    @Override
    public void install(AndroidApp app) throws AndroidSdkException {
        CommandLine command = this.adbCommand("install", "-r", app.getAbsolutePath());
        String out = this.executeCommandQuietly(command, COMMAND_TIMEOUT * 6);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        if (!out.contains("Success")) {
            throw new AndroidSdkException("APK installation failed. Output:\n" + out);
        }
    }

    @Override
    public boolean start(AndroidApp app) throws AndroidSdkException {
        if (!this.isInstalled(app)) {
            this.install(app);
        }
        String mainActivity = app.getMainActivity().replace(app.getBasePackage(), "");
        CommandLine command = this.adbCommand("shell", "am", "start", "-a", "android.intent.action.MAIN", "-n", app.getBasePackage() + "/" + mainActivity);
        String out = this.executeCommandQuietly(command);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        return out.contains("Starting: Intent");
    }

    protected String executeCommandQuietly(CommandLine command) {
        return this.executeCommandQuietly(command, COMMAND_TIMEOUT.intValue());
    }

    protected String executeCommandQuietly(CommandLine command, long timeout) {
        try {
            return ShellCommand.exec(command, timeout);
        }
        catch (ShellCommandException e) {
            String logMessage = String.format("Could not execute command: %s", command);
            log.log(Level.WARNING, logMessage, e);
            return "";
        }
    }

    @Override
    public void uninstall(AndroidApp app) throws AndroidSdkException {
        CommandLine command = this.adbCommand("uninstall", app.getBasePackage());
        this.executeCommandQuietly(command);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void clearUserData(AndroidApp app) throws AndroidSdkException {
        CommandLine command = this.adbCommand("shell", "pm", "clear", app.getBasePackage());
        this.executeCommandQuietly(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(AndroidApp aut) throws AndroidDeviceException, AndroidSdkException {
        try {
            CommandLine command = this.adbCommand("shell", "am", "force-stop", aut.getBasePackage());
            this.executeCommandQuietly(command);
        }
        finally {
            this.freeSelendroidPort();
        }
        if (this.logcatWatchdog != null && this.logcatWatchdog.isWatching()) {
            this.logcatWatchdog.destroyProcess();
            this.logcatWatchdog = null;
        }
    }

    private void freeSelendroidPort() {
        if (this.port == null) {
            return;
        }
        CommandLine command = this.adbCommand("forward", "--remove", "tcp:" + this.port);
        try {
            ShellCommand.exec(command, 20000L);
        }
        catch (ShellCommandException e) {
            log.log(Level.WARNING, "Could not free Selendroid port", e);
        }
    }

    @Override
    public void startSelendroid(AndroidApp aut, int port, SelendroidCapabilities capabilities) throws AndroidSdkException {
        this.port = port;
        ArrayList argList = Lists.newArrayList((Object[])new String[]{"-e", "main_activity", aut.getMainActivity(), "-e", "server_port", Integer.toString(port)});
        if (capabilities.getSelendroidExtensions() != null) {
            argList.addAll(Lists.newArrayList((Object[])new String[]{"-e", "load_extensions", "true"}));
            if (capabilities.getBootstrapClassNames() != null) {
                argList.addAll(Lists.newArrayList((Object[])new String[]{"-e", "bootstrap", capabilities.getBootstrapClassNames()}));
            }
        }
        argList.add("io.selendroid." + aut.getBasePackage() + "/io.selendroid.server.ServerInstrumentation");
        Object[] args = argList.toArray(new String[argList.size()]);
        CommandLine command = this.adbCommand((String[])ObjectArrays.concat((Object[])new String[]{"shell", "am", "instrument"}, (Object[])args, String.class));
        String result = this.executeCommandQuietly(command);
        if (result.contains("FAILED")) {
            String detailedMessage;
            String genericMessage = "Could not start the app under test using instrumentation.";
            try {
                String[] instrumentCmd = (String[])ObjectArrays.concat((Object[])new String[]{"shell", "am", "instrument", "-w"}, (Object[])args, String.class);
                CommandLine getDetailedErrorCommand = this.adbCommand(instrumentCmd);
                String detailedResult = this.executeCommandQuietly(getDetailedErrorCommand);
                detailedMessage = detailedResult.contains("package") ? genericMessage + " Is the correct app under test installed? Read the details below:\n" + detailedResult : genericMessage + " Read the details below:\n" + detailedResult;
            }
            catch (Exception e) {
                throw new SelendroidException(genericMessage, (Throwable)e);
            }
            throw new SelendroidException(detailedMessage);
        }
        this.forwardSelendroidPort(port);
        if (this.isLoggingEnabled()) {
            this.startLogging();
        }
    }

    @Override
    public void forwardPort(int local, int remote) {
        CommandLine command = this.adbCommand("forward", "tcp:" + local, "tcp:" + remote);
        try {
            ShellCommand.exec(command, 20000L);
        }
        catch (ShellCommandException forwardException) {
            String debugForwardList;
            try {
                debugForwardList = ShellCommand.exec(this.adbCommand("forward", "--list"), 10000L);
            }
            catch (ShellCommandException listException) {
                debugForwardList = "Could not get list of forwarded ports.";
            }
            throw new SelendroidException("Could not forward port: " + command + "\nList of forwarded ports:\n" + debugForwardList, (Throwable)forwardException);
        }
    }

    private void forwardSelendroidPort(int port) {
        this.forwardPort(port, port);
    }

    @Override
    public boolean isSelendroidRunning() {
        String responseValue;
        HttpResponse response;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String url = WD_STATUS_ENDPOINT.replace("8080", String.valueOf(this.port));
        log.info("Using url: " + url);
        HttpGet request = new HttpGet(url);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error checking if selendroid-server has started.", e);
            log.info("Assuming server has not started");
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        log.info("Got response status code: " + statusCode);
        try {
            responseValue = IOUtils.toString((InputStream)response.getEntity().getContent());
            log.info("Got response value: " + responseValue);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error reading response from selendroid-server", e);
            log.info("Assuming server has not started");
            return false;
        }
        return statusCode == 200 && responseValue.contains("selendroid");
    }

    @Override
    public int getSelendroidsPort() {
        return this.port;
    }

    @Override
    public List<LogEntry> getLogs() {
        ArrayList logs = Lists.newArrayList();
        String result = this.logoutput != null ? this.logoutput.toString() : "";
        String[] lines = result.split("\\r?\\n");
        log.fine("getting logcat");
        for (String line : lines) {
            Level l = line.startsWith("I") ? Level.INFO : (line.startsWith("W") ? Level.WARNING : (line.startsWith("S") ? Level.SEVERE : Level.FINE));
            logs.add(new LogEntry(l, System.currentTimeMillis(), line));
            log.fine(line);
        }
        return logs;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    private void startLogging() {
        this.logoutput = new ByteArrayOutputStream();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.logoutput));
        CommandLine command = this.adbCommand("logcat", "ResourceType:S", "dalvikvm:S", "Trace:S", "SurfaceFlinger:S", "StrictMode:S", "ExchangeService:S", "SVGAndroid:S", "skia:S", "LoaderManager:S", "ActivityThread:S", "-v", "time");
        log.info("starting logcat:");
        log.fine(command.toString());
        try {
            exec.execute(command, (ExecuteResultHandler)new DefaultExecuteResultHandler());
            this.logcatWatchdog = new ExecuteWatchdog(-1L);
            exec.setWatchdog(this.logcatWatchdog);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected String getProp(String key) {
        CommandLine command = this.adbCommand("shell", "getprop", key);
        String prop = this.executeCommandQuietly(command);
        return prop == null ? "" : prop.replace("\r", "").replace("\n", "");
    }

    protected static String extractValue(String regex, String output) {
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    @Override
    public boolean screenSizeMatches(String requestedScreenSize) {
        if (requestedScreenSize == null || requestedScreenSize.isEmpty()) {
            return true;
        }
        Pattern dimensionPattern = Pattern.compile("([0-9]+)x([0-9]+)");
        Matcher dimensionMatcher = dimensionPattern.matcher(requestedScreenSize);
        if (dimensionMatcher.matches()) {
            int width = Integer.parseInt(dimensionMatcher.group(1));
            int height = Integer.parseInt(dimensionMatcher.group(2));
            return this.getScreenSize().equals((Object)new Dimension(width, height));
        }
        return false;
    }

    @Override
    public String runAdbCommand(String parameter) {
        String[] params;
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        log.fine("running command: adb " + parameter);
        CommandLine command = this.adbCommand();
        for (String param : params = parameter.split(" ")) {
            command.addArgument(param, false);
        }
        String commandOutput = this.executeCommandQuietly(command);
        return commandOutput.trim();
    }

    @Override
    public byte[] takeScreenshot() throws AndroidDeviceException {
        RawImage rawImage;
        if (this.device == null) {
            throw new AndroidDeviceException("Device not accessible via ddmlib.");
        }
        try {
            rawImage = this.device.getScreenshot();
        }
        catch (IOException ioe) {
            throw new AndroidDeviceException("Unable to get frame buffer: " + ioe.getMessage());
        }
        catch (TimeoutException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new AndroidDeviceException(e.getMessage());
        }
        catch (AdbCommandRejectedException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new AndroidDeviceException(e.getMessage());
        }
        if (rawImage == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                image.setRGB(x, y, value);
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            if (!ImageIO.write((RenderedImage)image, "png", stream)) {
                throw new IOException("Failed to find png writer");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Cannot take screenshot", e);
            throw new AndroidDeviceException(e.getMessage());
        }
        byte[] raw = null;
        try {
            stream.flush();
            raw = stream.toByteArray();
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("I/O Error while capturing screenshot: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {}
        }
        return raw;
    }

    @Override
    public void inputKeyevent(int value) {
        this.executeCommandQuietly(this.adbCommand("shell", "input", "keyevent", "" + value));
        this.sleep(500);
    }

    @Override
    public void invokeActivity(String activity) {
        this.executeCommandQuietly(this.adbCommand("shell", "am", "start", "-a", activity));
        this.sleep(500);
    }

    @Override
    public void restartADB() {
        this.executeCommandQuietly(this.adbCommand("kill-server"));
        this.sleep(500);
        this.executeCommandQuietly(this.adbCommand("devices"));
    }

    private CommandLine adbCommand() {
        CommandLine command = new CommandLine(AndroidSdk.adb());
        if (this.isSerialConfigured()) {
            command.addArgument("-s", false);
            command.addArgument(this.serial, false);
        }
        return command;
    }

    private CommandLine adbCommand(String ... args) {
        CommandLine command = this.adbCommand();
        for (String arg : args) {
            command.addArgument(arg, false);
        }
        return command;
    }

    @Override
    public String getExternalStoragePath() {
        return this.runAdbCommand("shell echo $EXTERNAL_STORAGE");
    }

    @Override
    public String getCrashLog() {
        String directoryList;
        String crashLogFileName = ExternalStorageFile.APP_CRASH_LOG.toString();
        File crashLogFile = new File(this.getExternalStoragePath(), crashLogFileName);
        String crashLogDirPath = crashLogFile.getParentFile().getAbsolutePath();
        if (!crashLogDirPath.endsWith("/")) {
            crashLogDirPath = crashLogDirPath + "/";
        }
        if ((directoryList = this.executeCommandQuietly(this.adbCommand("shell", "ls", crashLogDirPath))).contains(crashLogFileName)) {
            return this.executeCommandQuietly(this.adbCommand("shell", "cat", crashLogFile.getAbsolutePath()));
        }
        return "";
    }

    @Override
    public String listRunningThirdPartyProcesses() {
        String psOutput = this.runAdbCommand("shell ps");
        StringBuilder sb = new StringBuilder();
        boolean isFirstHeaderLine = true;
        for (String line : Splitter.on((String)"\n").split((CharSequence)psOutput)) {
            boolean isThirdPartyProcess;
            boolean bl = isThirdPartyProcess = line.contains(".") && !line.contains("com.android");
            if (isFirstHeaderLine || isThirdPartyProcess) {
                sb.append(line + "\n");
            }
            isFirstHeaderLine = false;
        }
        return sb.toString();
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || this.device == null) {
            return false;
        }
        AbstractDevice that = (AbstractDevice)o;
        return this.device.equals(that.device);
    }

    public int hashCode() {
        return this.device.hashCode();
    }

    @Override
    public String getModel() {
        return this.model;
    }
}

