/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.android.impl;

import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidSdk;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.ShellCommandException;
import io.selendroid.standalone.io.ShellCommand;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;

public class DefaultAndroidApp
implements AndroidApp {
    private File apkFile;
    private String mainPackage = null;
    protected String mainActivity = null;
    private String versionName = null;

    public DefaultAndroidApp(File apkFile) {
        this.apkFile = apkFile;
    }

    private String extractApkDetails(String regex) throws ShellCommandException, AndroidSdkException {
        CommandLine line = new CommandLine(AndroidSdk.aapt());
        line.addArgument("dump", false);
        line.addArgument("badging", false);
        line.addArgument(this.apkFile.getAbsolutePath(), false);
        String output = ShellCommand.exec(line, 20000L);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String getBasePackage() throws AndroidSdkException {
        if (this.mainPackage == null) {
            try {
                this.mainPackage = this.extractApkDetails("package: name='(.*?)'");
            }
            catch (ShellCommandException e) {
                throw new SelendroidException("The base package name of the apk " + this.apkFile.getName() + " cannot be extracted.");
            }
        }
        return this.mainPackage;
    }

    @Override
    public String getMainActivity() throws AndroidSdkException {
        if (this.mainActivity == null) {
            try {
                this.mainActivity = this.extractApkDetails("launchable-activity: name='(.*?)'");
            }
            catch (ShellCommandException e) {
                throw new SelendroidException("The main activity of the apk " + this.apkFile.getName() + " cannot be extracted.");
            }
        }
        return this.mainActivity;
    }

    @Override
    public void setMainActivity(String mainActivity) {
        this.mainActivity = mainActivity;
    }

    @Override
    public void deleteFileFromWithinApk(String file) throws ShellCommandException, AndroidSdkException {
        CommandLine line = new CommandLine(AndroidSdk.aapt());
        line.addArgument("remove", false);
        line.addArgument(this.apkFile.getAbsolutePath(), false);
        line.addArgument(file, false);
        ShellCommand.exec(line, 20000L);
    }

    @Override
    public String getAbsolutePath() {
        return this.apkFile.getAbsolutePath();
    }

    @Override
    public String getVersionName() throws AndroidSdkException {
        if (this.versionName == null) {
            try {
                this.versionName = this.extractApkDetails("versionName='(.*?)'");
            }
            catch (ShellCommandException e) {
                throw new SelendroidException("The versionName of the apk " + this.apkFile.getName() + " cannot be extracted.");
            }
        }
        return this.versionName;
    }

    @Override
    public String getAppId() throws AndroidSdkException {
        return this.getBasePackage() + ":" + this.getVersionName();
    }
}

