/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.android.impl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.AndroidEmulatorPowerStateListener;
import io.selendroid.standalone.android.DeviceManager;
import io.selendroid.standalone.android.HardwareDeviceListener;
import io.selendroid.standalone.android.TelnetClient;
import io.selendroid.standalone.android.impl.DefaultHardwareDevice;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultDeviceManager
extends Thread
implements AndroidDebugBridge.IDeviceChangeListener,
DeviceManager {
    private static final Logger log = Logger.getLogger(DefaultDeviceManager.class.getName());
    private String adbPath;
    private List<HardwareDeviceListener> deviceListeners = new ArrayList<HardwareDeviceListener>();
    private List<AndroidEmulatorPowerStateListener> emulatorPowerStateListener = new ArrayList<AndroidEmulatorPowerStateListener>();
    private Map<IDevice, DefaultHardwareDevice> connectedDevices = new HashMap<IDevice, DefaultHardwareDevice>();
    private Map<String, IDevice> virtualDevices = new HashMap<String, IDevice>();
    private AndroidDebugBridge bridge;
    private boolean shouldKeepAdbAlive;

    public DefaultDeviceManager(String adbPath, boolean shouldKeepAdbAlive) {
        this.adbPath = adbPath;
        this.shouldKeepAdbAlive = shouldKeepAdbAlive;
    }

    protected void initializeAdbConnection() {
        block10: {
            IDevice[] devices;
            block9: {
                block8: {
                    try {
                        AndroidDebugBridge.init((boolean)false);
                    }
                    catch (IllegalStateException e) {
                        if (this.shouldKeepAdbAlive) break block8;
                        log.log(Level.WARNING, "AndroidDebugBridge may have been already initialized at this point. It is OK to proceed.", e);
                    }
                }
                this.bridge = AndroidDebugBridge.getBridge();
                if (this.bridge == null) {
                    this.bridge = AndroidDebugBridge.createBridge((String)this.adbPath, (boolean)false);
                }
                devices = this.bridge.getDevices();
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
                if (devices.length <= 0) break block9;
                for (int i = 0; i < devices.length; ++i) {
                    this.deviceConnected(devices[i]);
                    log.info("my devices: " + devices[i].getAvdName());
                }
                break block10;
            }
            long timeout = System.currentTimeMillis() + 2000L;
            while ((devices = this.bridge.getDevices()).length == 0 && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (devices.length <= 0) break block10;
            for (int i = 0; i < devices.length; ++i) {
                this.deviceConnected(devices[i]);
                log.info("my devices: " + devices[i].getAvdName());
            }
        }
    }

    @Override
    public void shutdown() {
        log.info("Notifying device listener about shutdown");
        for (HardwareDeviceListener listener : this.deviceListeners) {
            for (AndroidDevice androidDevice : this.connectedDevices.values()) {
                listener.onDeviceDisconnected(this.connectedDevices.get(androidDevice));
            }
        }
        log.info("Removing Device Manager listener from ADB");
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        if (!this.shouldKeepAdbAlive) {
            AndroidDebugBridge.disconnectBridge();
        }
        AndroidDebugBridge.terminate();
        log.info("stopping Device Manager");
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if (4 == changeMask && !device.isEmulator()) {
            for (HardwareDeviceListener listener : this.deviceListeners) {
                listener.onDeviceChanged(this.connectedDevices.get(device));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(IDevice device) {
        if (device == null) {
            return;
        }
        if (device.isEmulator()) {
            String serial = device.getSerialNumber();
            Integer port = Integer.parseInt(serial.replace("emulator-", ""));
            String avdName = null;
            TelnetClient client = null;
            try {
                client = new TelnetClient(port);
                avdName = client.sendCommand("avd name");
            }
            catch (AndroidDeviceException e) {
                String logMessage = "Could not get avdName for device " + serial;
                log.log(Level.WARNING, logMessage, e);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            this.virtualDevices.put(avdName, device);
            for (AndroidEmulatorPowerStateListener listener : this.emulatorPowerStateListener) {
                listener.onDeviceStarted(avdName, device.getSerialNumber());
            }
        } else {
            this.connectedDevices.put(device, new DefaultHardwareDevice(device));
            for (HardwareDeviceListener listener : this.deviceListeners) {
                listener.onDeviceConnected(this.connectedDevices.get(device));
            }
        }
    }

    public void deviceDisconnected(IDevice device) {
        if (device == null) {
            return;
        }
        if (device.isEmulator()) {
            this.virtualDevices.remove(device.getAvdName());
            for (AndroidEmulatorPowerStateListener listener : this.emulatorPowerStateListener) {
                listener.onDeviceStopped(device.getSerialNumber());
            }
        } else if (this.connectedDevices.containsKey(device)) {
            for (HardwareDeviceListener listener : this.deviceListeners) {
                listener.onDeviceDisconnected(this.connectedDevices.get(device));
            }
            this.connectedDevices.remove(device);
        }
    }

    @Override
    public void registerListener(HardwareDeviceListener deviceListener) {
        this.deviceListeners.add(deviceListener);
    }

    @Override
    public void unregisterListener(HardwareDeviceListener deviceListener) {
        if (this.deviceListeners.contains(deviceListener)) {
            this.deviceListeners.remove(deviceListener);
        }
    }

    @Override
    public void registerListener(AndroidEmulatorPowerStateListener deviceListener) {
        this.emulatorPowerStateListener.add(deviceListener);
    }

    @Override
    public void unregisterListener(AndroidEmulatorPowerStateListener deviceListener) {
        if (this.emulatorPowerStateListener.contains(deviceListener)) {
            this.emulatorPowerStateListener.remove(deviceListener);
        }
    }

    @Override
    public void initialize(HardwareDeviceListener defaultHardwareListener, AndroidEmulatorPowerStateListener emulatorListener) {
        this.registerListener(defaultHardwareListener);
        this.registerListener(emulatorListener);
        this.initializeAdbConnection();
    }

    @Override
    public IDevice getVirtualDevice(String avdName) {
        return this.virtualDevices.get(avdName);
    }
}

