/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.android.impl;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import io.selendroid.common.device.DeviceTargetPlatform;
import io.selendroid.standalone.android.impl.AbstractDevice;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Dimension;

public class DefaultHardwareDevice
extends AbstractDevice {
    private static final Logger log = Logger.getLogger(DefaultHardwareDevice.class.getName());
    private String model = null;
    private Locale locale = null;
    private DeviceTargetPlatform targetPlatform = null;
    private Dimension screenSize = null;

    public DefaultHardwareDevice(IDevice device) {
        super(device);
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.model = this.getProp("ro.product.model");
        }
        return this.model;
    }

    @Override
    protected String getProp(String key) {
        return this.device.getProperty(key);
    }

    @Override
    public DeviceTargetPlatform getTargetPlatform() {
        if (this.targetPlatform == null) {
            String version = this.getProp("ro.build.version.sdk");
            this.targetPlatform = DeviceTargetPlatform.fromInt((String)version);
        }
        return this.targetPlatform;
    }

    @Override
    public Dimension getScreenSize() {
        if (this.screenSize == null) {
            try {
                RawImage screenshot = this.device.getScreenshot();
                this.screenSize = new Dimension(screenshot.width, screenshot.height);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to determine screen size", e);
            }
        }
        return this.screenSize;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = new Locale(this.getProp("persist.sys.language"), this.getProp("persist.sys.country"));
        }
        return this.locale;
    }

    @Override
    public boolean isDeviceReady() {
        return true;
    }

    public String toString() {
        return "HardwareDevice [serial=" + this.serial + ", model=" + this.getModel() + ", targetVersion=" + this.getTargetPlatform() + "]";
    }

    @Override
    public String getSerial() {
        return this.serial;
    }
}

