/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.android.impl;

import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.ShellCommandException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstalledAndroidApp
implements AndroidApp {
    private String packageName;
    private String activityName;
    private String version;

    public InstalledAndroidApp(String appInfo) {
        Pattern infoPattern = Pattern.compile("(.+):(.+)/(.+)");
        Matcher patternMatcher = infoPattern.matcher(appInfo);
        if (!patternMatcher.matches()) {
            throw new RuntimeException("Format for installed app is:  tld.company.app:version/ActivityClass");
        }
        this.packageName = patternMatcher.group(1);
        this.version = patternMatcher.group(2);
        this.activityName = patternMatcher.group(3);
    }

    @Override
    public String getBasePackage() throws AndroidSdkException {
        return this.packageName;
    }

    @Override
    public String getMainActivity() throws AndroidSdkException {
        return this.activityName.contains(".") ? this.activityName : this.packageName + "." + this.activityName;
    }

    @Override
    public void setMainActivity(String mainActivity) {
        this.activityName = mainActivity;
    }

    @Override
    public String getVersionName() throws AndroidSdkException {
        return this.version;
    }

    @Override
    public void deleteFileFromWithinApk(String file) throws ShellCommandException, AndroidSdkException {
    }

    @Override
    public String getAppId() throws AndroidSdkException {
        return this.packageName + ":" + this.version;
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }
}

