/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.builder;

import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidSdk;
import io.selendroid.standalone.android.JavaSdk;
import io.selendroid.standalone.android.impl.DefaultAndroidApp;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.ShellCommandException;
import io.selendroid.standalone.io.ShellCommand;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SelendroidServerBuilder {
    public static final String SELENDROID_TEST_APP_PACKAGE = "io.selendroid.testapp";
    private static final Logger log = Logger.getLogger(SelendroidServerBuilder.class.getName());
    public static final String SELENDROID_FINAL_NAME = "selendroid-server.apk";
    public static final String PREBUILD_SELENDROID_SERVER_PATH_PREFIX = "/prebuild/selendroid-server-";
    public static final String ANDROID_APPLICATION_XML_TEMPLATE = "/AndroidManifestTemplate.xml";
    public static final String ICON = "android:icon=\"@drawable/selenium_icon\"";
    private String selendroidPrebuildServerPath = null;
    private String selendroidApplicationXmlTemplate = null;
    private AndroidApp selendroidServer = null;
    private AndroidApp applicationUnderTest = null;
    private SelendroidConfiguration serverConfiguration = null;
    private String storepass = null;
    private String alias = null;
    private X509Certificate cert509;

    SelendroidServerBuilder(String selendroidPrebuildServerPath, String selendroidApplicationXmlTemplate) {
        this.selendroidPrebuildServerPath = selendroidPrebuildServerPath;
        this.selendroidApplicationXmlTemplate = selendroidApplicationXmlTemplate;
    }

    SelendroidServerBuilder(String selendroidPrebuildServerPath, String selendroidApplicationXmlTemplate, SelendroidConfiguration selendroidConfiguration) {
        this.selendroidPrebuildServerPath = selendroidPrebuildServerPath;
        this.selendroidApplicationXmlTemplate = selendroidApplicationXmlTemplate;
        this.serverConfiguration = selendroidConfiguration;
    }

    public SelendroidServerBuilder() {
        this(null);
    }

    public SelendroidServerBuilder(SelendroidConfiguration serverConfiguration) {
        this.selendroidPrebuildServerPath = PREBUILD_SELENDROID_SERVER_PATH_PREFIX + SelendroidServerBuilder.getJarVersionNumber() + ".apk";
        this.selendroidApplicationXmlTemplate = ANDROID_APPLICATION_XML_TEMPLATE;
        this.serverConfiguration = serverConfiguration;
    }

    void init(AndroidApp aut) throws IOException, ShellCommandException {
        this.applicationUnderTest = aut;
        File customizedServer = File.createTempFile("selendroid-server", ".apk");
        log.info("Creating customized Selendroid-server: " + customizedServer.getAbsolutePath());
        InputStream is = this.getResourceAsStream(this.selendroidPrebuildServerPath);
        IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(customizedServer));
        IOUtils.closeQuietly((InputStream)is);
        this.selendroidServer = new DefaultAndroidApp(customizedServer);
    }

    public AndroidApp createSelendroidServer(AndroidApp aut) throws IOException, ShellCommandException, AndroidSdkException {
        log.info("create SelendroidServer for apk: " + aut.getAbsolutePath());
        this.init(aut);
        this.cleanUpPrebuildServer();
        File selendroidServer = this.createAndAddCustomizedAndroidManifestToSelendroidServer();
        File outputFile = new File(FileUtils.getTempDirectory(), String.format("selendroid-server-%s-%s.apk", this.applicationUnderTest.getBasePackage(), SelendroidServerBuilder.getJarVersionNumber()));
        return this.signTestServer(selendroidServer, outputFile);
    }

    private void deleteFileFromAppSilently(AndroidApp app, String file) throws AndroidSdkException {
        if (app == null) {
            throw new IllegalArgumentException("Required parameter 'app' is null.");
        }
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("Required parameter 'file' is null or empty.");
        }
        try {
            app.deleteFileFromWithinApk(file);
        }
        catch (ShellCommandException shellCommandException) {
            // empty catch block
        }
    }

    public AndroidApp resignApp(File appFile) throws ShellCommandException, AndroidSdkException {
        DefaultAndroidApp app = new DefaultAndroidApp(appFile);
        this.deleteFileFromAppSilently(app, "META-INF/MANIFEST.MF");
        this.deleteFileFromAppSilently(app, "META-INF/CERT.RSA");
        this.deleteFileFromAppSilently(app, "META-INF/CERT.SF");
        this.deleteFileFromAppSilently(app, "META-INF/ANDROIDD.SF");
        this.deleteFileFromAppSilently(app, "META-INF/ANDROIDD.RSA");
        this.deleteFileFromAppSilently(app, "META-INF/NDKEYSTO.SF");
        this.deleteFileFromAppSilently(app, "META-INF/NDKEYSTO.RSA");
        File outputFile = new File(appFile.getParentFile(), "resigned-" + appFile.getName());
        return this.signTestServer(appFile, outputFile);
    }

    File createAndAddCustomizedAndroidManifestToSelendroidServer() throws IOException, ShellCommandException, AndroidSdkException {
        int i;
        String targetPackageName = this.applicationUnderTest.getBasePackage();
        File tempdir = new File(FileUtils.getTempDirectoryPath() + File.separatorChar + targetPackageName + System.currentTimeMillis());
        if (!tempdir.exists()) {
            tempdir.mkdirs();
        }
        File customizedManifest = new File(tempdir, "AndroidManifest.xml");
        log.info("Adding target package '" + targetPackageName + "' to " + customizedManifest.getAbsolutePath());
        InputStream inputStream = this.getResourceAsStream(this.selendroidApplicationXmlTemplate);
        if (inputStream == null) {
            throw new SelendroidException("AndroidApplication.xml template file was not found.");
        }
        String content = IOUtils.toString((InputStream)inputStream, (String)Charset.defaultCharset().displayName());
        int cnt = 0;
        for (i = content.toLowerCase().indexOf("package"); i < content.length(); ++i) {
            if (content.charAt(i) == '\"') {
                ++cnt;
            }
            if (cnt == 2) break;
        }
        content = content.substring(0, i) + "." + targetPackageName + content.substring(i);
        log.info("Final Manifest File:\n" + content);
        content = content.replaceAll(SELENDROID_TEST_APP_PACKAGE, targetPackageName);
        if (content.contains(ICON)) {
            content = content.replaceAll(ICON, "");
        }
        FileOutputStream outputStream = new FileOutputStream(customizedManifest);
        IOUtils.write((String)content, (OutputStream)outputStream, (String)Charset.defaultCharset().displayName());
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        CommandLine createManifestApk = new CommandLine(AndroidSdk.aapt());
        createManifestApk.addArgument("package", false);
        createManifestApk.addArgument("-M", false);
        createManifestApk.addArgument(customizedManifest.getAbsolutePath(), false);
        createManifestApk.addArgument("-I", false);
        createManifestApk.addArgument(AndroidSdk.androidJar(), false);
        createManifestApk.addArgument("-F", false);
        createManifestApk.addArgument(tempdir.getAbsolutePath() + File.separatorChar + "manifest.apk", false);
        createManifestApk.addArgument("-f", false);
        log.info(ShellCommand.exec(createManifestApk, 20000L));
        ZipFile manifestApk = new ZipFile(new File(tempdir.getAbsolutePath() + File.separatorChar + "manifest.apk"));
        ZipArchiveEntry binaryManifestXml = manifestApk.getEntry("AndroidManifest.xml");
        File finalSelendroidServerFile = new File(tempdir.getAbsolutePath() + SELENDROID_FINAL_NAME);
        ZipArchiveOutputStream finalSelendroidServer = new ZipArchiveOutputStream(finalSelendroidServerFile);
        finalSelendroidServer.putArchiveEntry((ArchiveEntry)binaryManifestXml);
        IOUtils.copy((InputStream)manifestApk.getInputStream(binaryManifestXml), (OutputStream)finalSelendroidServer);
        ZipFile selendroidPrebuildApk = new ZipFile(this.selendroidServer.getAbsolutePath());
        Enumeration entries = selendroidPrebuildApk.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry dd = (ZipArchiveEntry)entries.nextElement();
            finalSelendroidServer.putArchiveEntry((ArchiveEntry)dd);
            IOUtils.copy((InputStream)selendroidPrebuildApk.getInputStream(dd), (OutputStream)finalSelendroidServer);
        }
        finalSelendroidServer.closeArchiveEntry();
        finalSelendroidServer.close();
        manifestApk.close();
        log.info("file: " + finalSelendroidServerFile.getAbsolutePath());
        return finalSelendroidServerFile;
    }

    AndroidApp signTestServer(File customSelendroidServer, File outputFileName) throws ShellCommandException, AndroidSdkException {
        String output;
        CommandLine commandline;
        if (outputFileName == null) {
            throw new IllegalArgumentException("outputFileName parameter is null.");
        }
        File androidKeyStore = this.androidDebugKeystore();
        if (!androidKeyStore.isFile()) {
            commandline = new CommandLine(JavaSdk.keytool());
            commandline.addArgument("-genkey", false);
            commandline.addArgument("-v", false);
            commandline.addArgument("-keystore", false);
            commandline.addArgument(androidKeyStore.toString(), false);
            commandline.addArgument("-storepass", false);
            commandline.addArgument("android", false);
            commandline.addArgument("-alias", false);
            commandline.addArgument("androiddebugkey", false);
            commandline.addArgument("-keypass", false);
            commandline.addArgument("android", false);
            commandline.addArgument("-dname", false);
            commandline.addArgument("CN=Android Debug,O=Android,C=US", false);
            commandline.addArgument("-storetype", false);
            commandline.addArgument("JKS", false);
            commandline.addArgument("-sigalg", false);
            commandline.addArgument("MD5withRSA", false);
            commandline.addArgument("-keyalg", false);
            commandline.addArgument("RSA", false);
            commandline.addArgument("-validity", false);
            commandline.addArgument("9999", false);
            output = ShellCommand.exec(commandline, 20000L);
            log.info("A new keystore has been created: " + output);
        }
        commandline = new CommandLine(JavaSdk.jarsigner());
        commandline.addArgument("-sigalg", false);
        commandline.addArgument(this.getSigAlg(), false);
        commandline.addArgument("-digestalg", false);
        commandline.addArgument("SHA1", false);
        commandline.addArgument("-signedjar", false);
        commandline.addArgument(outputFileName.getAbsolutePath(), false);
        commandline.addArgument("-storepass", false);
        commandline.addArgument(this.storepass != null ? this.storepass : "android", false);
        commandline.addArgument("-keystore", false);
        commandline.addArgument(androidKeyStore.toString(), false);
        commandline.addArgument(customSelendroidServer.getAbsolutePath(), false);
        commandline.addArgument(this.alias != null ? this.alias : "androiddebugkey", false);
        output = ShellCommand.exec(commandline, 20000L);
        if (log.isLoggable(Level.INFO)) {
            log.info("App signing output: " + output);
        }
        log.info("The app has been signed: " + outputFileName.getAbsolutePath());
        return new DefaultAndroidApp(outputFileName);
    }

    private File androidDebugKeystore() {
        if (this.serverConfiguration == null || this.serverConfiguration.getKeystore() == null) {
            return new File(FileUtils.getUserDirectory(), File.separatorChar + ".android" + File.separatorChar + "debug.keystore");
        }
        this.storepass = this.serverConfiguration.getKeystorePassword();
        this.alias = this.serverConfiguration.getKeystoreAlias();
        return new File(this.serverConfiguration.getKeystore());
    }

    void cleanUpPrebuildServer() throws ShellCommandException, AndroidSdkException {
        this.selendroidServer.deleteFileFromWithinApk("META-INF/CERT.RSA");
        this.selendroidServer.deleteFileFromWithinApk("META-INF/CERT.SF");
        this.selendroidServer.deleteFileFromWithinApk("AndroidManifest.xml");
    }

    AndroidApp getSelendroidServer() {
        return this.selendroidServer;
    }

    AndroidApp getApplicationUnderTest() {
        return this.applicationUnderTest;
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream is = this.getClass().getResourceAsStream(resource);
        if (is == null) {
            try {
                is = new FileInputStream(new File(resource));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new SelendroidException("The resource '" + resource + "' was not found.");
        }
        return is;
    }

    public static String getJarVersionNumber() {
        Manifest manifest;
        Class<SelendroidStandaloneDriver> clazz = SelendroidStandaloneDriver.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "dev";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
        }
        catch (Exception e) {
            return "";
        }
        Attributes attr = manifest.getMainAttributes();
        return attr.getValue("version");
    }

    private String getSigAlg() {
        String sigAlg = "MD5withRSA";
        try {
            String keystoreFile;
            if (this.serverConfiguration != null && (keystoreFile = this.serverConfiguration.getKeystore()) != null) {
                char[] keystorePasswordCharArray;
                FileInputStream in = new FileInputStream(keystoreFile);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                String keystorePassword = this.serverConfiguration.getKeystorePassword();
                char[] cArray = keystorePasswordCharArray = keystorePassword == null ? null : keystorePassword.toCharArray();
                if (keystorePasswordCharArray == null) {
                    throw new RuntimeException("No keystore password configured.");
                }
                keystore.load(in, keystorePasswordCharArray);
                this.cert509 = (X509Certificate)keystore.getCertificate(this.serverConfiguration.getKeystoreAlias());
                sigAlg = this.cert509.getSigAlgName();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Error getting signature algorithm for jarsigner. Defaulting to %s. Reason: %s", sigAlg, e.getMessage()));
        }
        return sigAlg;
    }
}

