/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.io;

import io.selendroid.standalone.exceptions.ShellCommandException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;

public class ShellCommand {
    private static final Logger log = Logger.getLogger(ShellCommand.class.getName());

    public static String exec(CommandLine commandLine) throws ShellCommandException {
        return ShellCommand.exec(commandLine, 20000L);
    }

    public static String exec(CommandLine commandline, long timeoutInMillies) throws ShellCommandException {
        log.info("Executing shell command: " + commandline);
        PrintingLogOutputStream outputStream = new PrintingLogOutputStream();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setWatchdog(new ExecuteWatchdog(timeoutInMillies));
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)((Object)outputStream));
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            exec.execute(commandline);
        }
        catch (Exception e) {
            throw new ShellCommandException("Error executing shell command: " + commandline, new ShellCommandException(outputStream.getOutput()));
        }
        String result = outputStream.getOutput().trim();
        log.info("Shell command output\n-->\n" + result + "\n<--");
        return result;
    }

    public static void execAsync(CommandLine commandline) throws ShellCommandException {
        ShellCommand.execAsync(null, commandline);
    }

    public static void execAsync(String display, CommandLine commandline) throws ShellCommandException {
        log.info("executing async command: " + commandline);
        DefaultExecutor exec = new DefaultExecutor();
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)((Object)new PrintingLogOutputStream()));
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            if (display == null || display.isEmpty()) {
                exec.execute(commandline, (ExecuteResultHandler)handler);
            } else {
                Map env = EnvironmentUtils.getProcEnvironment();
                EnvironmentUtils.addVariableToEnvironment((Map)env, (String)("DISPLAY=:" + display));
                exec.execute(commandline, env, (ExecuteResultHandler)handler);
            }
        }
        catch (Exception e) {
            throw new ShellCommandException("Error executing shell command: " + commandline, e);
        }
    }

    private static class PrintingLogOutputStream
    extends LogOutputStream {
        private StringBuilder output = new StringBuilder();

        private PrintingLogOutputStream() {
        }

        protected void processLine(String line, int level) {
            log.fine("OUTPUT FROM PROCESS: " + line);
            this.output.append(line).append("\n");
        }

        public String getOutput() {
            return this.output.toString();
        }
    }
}

