/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server;

import io.selendroid.server.common.BaseRequestHandler;
import io.selendroid.server.common.Response;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseSelendroidStandaloneHandler
extends BaseRequestHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public BaseSelendroidStandaloneHandler(String mappedUri) {
        super(mappedUri);
    }

    protected abstract Response handleRequest(HttpRequest var1, JSONObject var2) throws JSONException;

    public Response handle(HttpRequest request) throws JSONException {
        JSONObject payload = this.getPayload(request);
        this.logHandlerCalled(payload);
        return this.handleRequest(request, payload);
    }

    protected SelendroidStandaloneDriver getSelendroidDriver(HttpRequest request) {
        return (SelendroidStandaloneDriver)request.data().get("DRIVER_KEY");
    }

    protected ActiveSession getActiveSession(HttpRequest request) {
        SelendroidStandaloneDriver driver = this.getSelendroidDriver(request);
        if (driver == null) {
            this.log.warning("Cannot get session, no selendroid driver.");
            return null;
        }
        return driver.getActiveSession(this.getSessionId(request));
    }

    private void logHandlerCalled(JSONObject payload) {
        String message = "Selendroid standalone handler: " + ((Object)((Object)this)).getClass().getSimpleName();
        if (payload != null) {
            try {
                message = message + ", payload:\n" + payload.toString(2);
            }
            catch (JSONException e) {
                this.log.log(Level.WARNING, "Cannot debug-print request payload", e);
            }
        }
        this.log.log(Level.FINE, message);
    }
}

