/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server;

import io.selendroid.server.common.ServerDetails;
import io.selendroid.server.common.StatusServlet;
import io.selendroid.server.common.http.HttpServer;
import io.selendroid.server.common.http.HttpServlet;
import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.server.SelendroidServlet;
import io.selendroid.standalone.server.grid.SelfRegisteringRemote;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelendroidStandaloneServer {
    private static final Logger log = Logger.getLogger(SelendroidStandaloneServer.class.getName());
    private HttpServer webServer;
    private SelendroidConfiguration config;
    private SelendroidStandaloneDriver driver = null;

    protected SelendroidStandaloneServer(SelendroidConfiguration config, SelendroidStandaloneDriver driver) throws AndroidSdkException {
        this.config = config;
        this.driver = driver;
        this.webServer = new HttpServer(config.getPort());
        this.init();
    }

    public SelendroidStandaloneServer(SelendroidConfiguration config) throws AndroidSdkException, AndroidDeviceException {
        this.config = config;
        this.webServer = new HttpServer(config.getPort());
        this.driver = this.initializeSelendroidServer();
        this.init();
    }

    protected void init() throws AndroidSdkException {
        this.webServer.addHandler((HttpServlet)new StatusServlet((ServerDetails)this.driver));
        this.webServer.addHandler((HttpServlet)new SelendroidServlet(this.driver, this.config));
    }

    protected SelendroidStandaloneDriver initializeSelendroidServer() throws AndroidSdkException, AndroidDeviceException {
        return new SelendroidStandaloneDriver(this.config);
    }

    public void start() {
        this.webServer.start();
        if (this.config.isGrid()) {
            try {
                new SelfRegisteringRemote(this.config, this.driver).performRegistration();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error registering selendroid into grid hub.", e);
            }
        }
        log.info("Selendroid standalone server has been started on port: " + this.config.getPort());
    }

    public void stop() {
        log.info("Stopping selendroid-standalone server");
        this.driver.quitSelendroid();
        this.webServer.stop();
    }

    public int getPort() {
        return this.webServer.getPort();
    }

    public SelendroidStandaloneDriver getDriver() {
        return this.driver;
    }
}

