/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.grid;

import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelfRegisteringRemote {
    private static final Logger log = Logger.getLogger(SelfRegisteringRemote.class.getName());
    public static final String ANDROIDDRIVER_APP = "io.selendroid.androiddriver";
    private SelendroidConfiguration config;
    private SelendroidStandaloneDriver driver;

    public SelfRegisteringRemote(SelendroidConfiguration config, SelendroidStandaloneDriver driver) {
        this.config = config;
        this.driver = driver;
    }

    public void performRegistration() throws Exception {
        String tmp = this.config.getRegistrationUrl();
        HttpClient client = HttpClientUtil.getHttpClient();
        URL registration = new URL(tmp);
        if (log.isLoggable(Level.INFO)) {
            log.info("Registering selendroid node to Selenium Grid hub :" + registration);
        }
        BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", registration.toExternalForm());
        JSONObject nodeConfig = this.getNodeConfig();
        String nodeConfigString = nodeConfig.toString();
        if (log.isLoggable(Level.INFO)) {
            log.info("Registering selendroid node with following config:\n" + nodeConfigString);
        }
        r.setEntity((HttpEntity)new StringEntity(nodeConfigString));
        HttpHost host = new HttpHost(registration.getHost(), registration.getPort());
        HttpResponse response = client.execute(host, (HttpRequest)r);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new SelendroidException("Error sending the registration request.");
        }
    }

    private JSONObject getNodeConfig() {
        JSONObject res = new JSONObject();
        try {
            res.put("class", (Object)"org.openqa.grid.common.RegistrationRequest");
            res.put("configuration", (Object)this.getConfiguration());
            JSONArray caps = new JSONArray();
            JSONArray devices = this.driver.getSupportedDevices();
            for (int i = 0; i < devices.length(); ++i) {
                JSONObject device = (JSONObject)devices.get(i);
                for (int x = 0; x < this.driver.getSupportedApps().length(); ++x) {
                    JSONObject capa = new JSONObject();
                    capa.put("screenSize", (Object)device.getString("screenSize"));
                    String version = device.getString("platformVersion");
                    capa.put("platformVersion", (Object)version);
                    capa.put("emulator", (Object)device.getString("emulator"));
                    if (ANDROIDDRIVER_APP.equals(this.driver.getSupportedApps().getJSONObject(x).get("basePackage"))) {
                        if (!this.config.isNoWebViewApp()) {
                            capa.put("browserName", (Object)"android");
                        }
                    } else {
                        capa.put("browserName", (Object)"selendroid");
                        capa.put("aut", this.driver.getSupportedApps().getJSONObject(x).get("appId"));
                    }
                    capa.put("platform", (Object)"ANDROID");
                    capa.put("version", (Object)version);
                    capa.put("maxInstances", this.config.getMaxInstances());
                    caps.put((Object)capa);
                }
            }
            res.put("capabilities", (Object)caps);
        }
        catch (JSONException e) {
            throw new SelendroidException(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private JSONObject getConfiguration() throws JSONException {
        URL registrationUrl;
        JSONObject configuration = new JSONObject();
        configuration.put("port", this.config.getPort());
        configuration.put("register", true);
        if (this.config.getProxy() != null) {
            configuration.put("proxy", (Object)this.config.getProxy());
        } else {
            configuration.put("proxy", (Object)"org.openqa.grid.selenium.proxy.DefaultRemoteProxy");
        }
        configuration.put("role", (Object)"node");
        configuration.put("registerCycle", 5000);
        configuration.put("maxSession", this.config.getMaxSession());
        try {
            registrationUrl = new URL(this.config.getRegistrationUrl());
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, "Grid hub url cannot be parsed", e);
            throw new SelendroidException("Grid hub url cannot be parsed: " + e.getMessage());
        }
        configuration.put("hubHost", (Object)registrationUrl.getHost());
        configuration.put("hubPort", registrationUrl.getPort());
        configuration.put("seleniumProtocol", (Object)"WebDriver");
        configuration.put("host", (Object)this.config.getServerHost());
        configuration.put("remoteHost", (Object)("http://" + this.config.getServerHost() + ":" + this.config.getPort()));
        return configuration;
    }
}

