/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import io.selendroid.server.common.Response;
import io.selendroid.server.common.SelendroidResponse;
import io.selendroid.server.common.StatusCode;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.internal.Base64Encoder;

public class CaptureScreenshot
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(CaptureScreenshot.class.getName());

    public CaptureScreenshot(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        byte[] rawPng;
        try {
            rawPng = this.getSelendroidDriver(request).takeScreenshot(this.getSessionId(request));
        }
        catch (AndroidDeviceException e) {
            log.log(Level.SEVERE, "Cannot take screenshot", e);
            return new SelendroidResponse(this.getSessionId(request), StatusCode.UNKNOWN_ERROR, (Throwable)e);
        }
        String base64Png = new Base64Encoder().encode(rawPng);
        return new SelendroidResponse(this.getSessionId(request), (Object)base64Png);
    }
}

