/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import io.selendroid.common.SelendroidCapabilities;
import io.selendroid.server.common.Response;
import io.selendroid.server.common.SelendroidResponse;
import io.selendroid.server.common.StatusCode;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CreateSessionHandler
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(CreateSessionHandler.class.getName());

    public CreateSessionHandler(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        JSONObject desiredCapabilities = payload.getJSONObject("desiredCapabilities");
        try {
            String sessionID = this.getSelendroidDriver(request).createNewTestSession(desiredCapabilities);
            SelendroidCapabilities caps = this.getSelendroidDriver(request).getSessionCapabilities(sessionID);
            return new SelendroidResponse(sessionID, (Object)new JSONObject(caps.asMap()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error while creating new session", e);
            return new SelendroidResponse("", StatusCode.SESSION_NOT_CREATED_EXCEPTION, (Throwable)e);
        }
    }
}

