/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import io.selendroid.server.common.Response;
import io.selendroid.server.common.UiResponse;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class InspectorScreenshotHandler
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(InspectorScreenshotHandler.class.getName());

    public InspectorScreenshotHandler(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        String sessionId = this.getSessionId(request);
        log.info("inspector screenshot handler, sessionId: " + sessionId);
        if (sessionId == null || sessionId.isEmpty()) {
            ActiveSession firstActiveSession = this.getFirstActiveSession(this.getSelendroidDriver(request));
            if (firstActiveSession != null) {
                sessionId = firstActiveSession.getSessionId();
                log.info("Selected first session, id: " + firstActiveSession.getSessionId());
            } else {
                return new UiResponse("", (Object)"Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
            }
        }
        byte[] screenshot = null;
        try {
            screenshot = this.getSelendroidDriver(request).takeScreenshot(sessionId);
        }
        catch (AndroidDeviceException e) {
            log.log(Level.SEVERE, "Cannot take screenshot for inspector", e);
        }
        return new UiResponse(sessionId != null ? sessionId : "", (Object)screenshot);
    }

    private ActiveSession getFirstActiveSession(SelendroidStandaloneDriver driver) {
        if (driver.getActiveSessions() != null && driver.getActiveSessions().size() >= 1) {
            return driver.getActiveSessions().get(0);
        }
        return null;
    }
}

