/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import io.netty.handler.codec.http.HttpMethod;
import io.selendroid.server.common.Response;
import io.selendroid.server.common.UiResponse;
import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import io.selendroid.standalone.server.JsResult;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class InspectorTreeHandler
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(InspectorTreeHandler.class.getName());

    public InspectorTreeHandler(String mappedUri) {
        super(mappedUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        ActiveSession session;
        String sessionId = this.getSessionId(request);
        log.info("inspector tree handler, sessionId: " + sessionId);
        if (sessionId == null || sessionId.isEmpty()) {
            if (this.getSelendroidDriver(request).getActiveSessions() == null || this.getSelendroidDriver(request).getActiveSessions().size() < 1) return new UiResponse("", (Object)"Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
            session = this.getSelendroidDriver(request).getActiveSessions().get(0);
            log.info("Selected sessionId: " + session.getSessionId());
        } else {
            session = this.getActiveSession(request);
        }
        try {
            HttpResponse r = HttpClientUtil.executeRequest("http://localhost:" + session.getSelendroidServerPort() + "/inspector/tree", HttpMethod.GET);
            return new JsResult(EntityUtils.toString((HttpEntity)r.getEntity(), (Charset)Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot get element tree for inspector", e);
            throw new SelendroidException((Throwable)e);
        }
    }
}

