/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import io.netty.handler.codec.http.HttpMethod;
import io.selendroid.server.common.Response;
import io.selendroid.server.common.SelendroidResponse;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.impl.DefaultAndroidEmulator;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkConnectionHandler
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(NetworkConnectionHandler.class.getName());

    public NetworkConnectionHandler(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        String sessionId = this.getSessionId(request);
        ActiveSession session = this.getActiveSession(request);
        String url = "http://localhost:" + session.getSelendroidServerPort() + request.uri();
        Integer connectionType = this.getPayload(request).getJSONObject("parameters").getInt("type");
        try {
            JSONObject r = HttpClientUtil.parseJsonResponse(HttpClientUtil.executeRequest(url, HttpMethod.GET));
            if (r.getInt("value") % 2 == connectionType % 2) {
                return new SelendroidResponse(sessionId, null);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot change network connection", e);
            return new SelendroidResponse(sessionId, null);
        }
        Boolean airplaneMode = connectionType % 2 == 1;
        AndroidDevice device = this.getSelendroidDriver(request).getActiveSession(this.getSessionId(request)).getDevice();
        int deviceAPILevel = Integer.parseInt(device.getTargetPlatform().getApi());
        device.invokeActivity("android.settings.AIRPLANE_MODE_SETTINGS");
        device.runAdbCommand("shell input tap 600 100");
        device.inputKeyevent(20);
        device.inputKeyevent(23);
        if (airplaneMode.booleanValue()) {
            device.restartADB();
            for (ActiveSession activeSession : this.getSelendroidDriver(request).getActiveSessions()) {
                device.forwardPort(activeSession.getSelendroidServerPort(), activeSession.getSelendroidServerPort());
            }
        } else if (deviceAPILevel == 17 && device instanceof DefaultAndroidEmulator) {
            device.runAdbCommand("shell svc data disable");
            device.runAdbCommand("shell svc data enable");
        }
        device.inputKeyevent(19);
        device.inputKeyevent(23);
        return new SelendroidResponse(sessionId, (Object)(airplaneMode != false ? 1 : 6));
    }
}

