/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.handler;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpMethod;
import io.selendroid.server.common.Response;
import io.selendroid.server.common.SelendroidResponse;
import io.selendroid.server.common.StatusCode;
import io.selendroid.server.common.exceptions.AppCrashedException;
import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.server.common.http.HttpRequest;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.server.BaseSelendroidStandaloneHandler;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.logging.LogEntry;

public class ProxyToDeviceHandler
extends BaseSelendroidStandaloneHandler {
    private static final Logger log = Logger.getLogger(ProxyToDeviceHandler.class.getName());

    public ProxyToDeviceHandler(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handleRequest(HttpRequest request, JSONObject payload) throws JSONException {
        String sessionId = this.getSessionId(request);
        if (sessionId == null || sessionId.isEmpty()) {
            String dataKeys = Joiner.on((String)", ").join(request.data().keySet());
            log.warning("Unable to retrieve session id from request with data: [" + dataKeys + "]");
            return this.respondWithFailure(sessionId, (Exception)new SelendroidException("No session id passed to the request."));
        }
        ActiveSession session = this.getActiveSession(request);
        if (session == null) {
            return this.respondWithFailure(sessionId, (Exception)new SelendroidException("No session found for sessionId: " + sessionId));
        }
        if (session.isInvalid()) {
            return this.respondWithFailure(sessionId, (Exception)new SelendroidException("The test session has been marked as invalid. This happens if a hardware device was disconnected but a test session was still active on the device."));
        }
        String url = "http://localhost:" + session.getSelendroidServerPort() + request.uri();
        String method = request.method();
        JSONObject response = null;
        int retries = 3;
        while (retries-- > 0) {
            try {
                response = this.proxyRequestToDevice(request, session, url, method);
                break;
            }
            catch (Exception e) {
                if (retries == 0) {
                    AndroidDevice device = session.getDevice();
                    String crashMessage = device.getCrashLog();
                    if (!crashMessage.isEmpty()) {
                        return this.respondWithFailure(sessionId, (Exception)new AppCrashedException(crashMessage));
                    }
                    if (device.isLoggingEnabled()) {
                        log.info("Failed to proxy request to the device, dumping logcat");
                        device.setVerbose();
                        for (LogEntry le : device.getLogs()) {
                            System.out.println(le.getMessage());
                        }
                    }
                    if (e instanceof SocketException) {
                        return this.respondWithServerOnDeviceUnreachable(sessionId, session.getDevice());
                    }
                    if (e instanceof NoHttpResponseException) {
                        return this.respondWithServerOnDeviceUnreachable(sessionId, session.getDevice());
                    }
                    return this.respondWithFailure(sessionId, (Exception)new SelendroidException("Unexpected error communicating with selendroid server on the device", (Throwable)e));
                }
                log.log(Level.SEVERE, "Failed to proxy request to Selendroid Server, retrying.", e);
            }
        }
        if (response == null) {
            return this.respondWithFailure(sessionId, (Exception)new SelendroidException("Selendroid server on the device became unreachable"));
        }
        Object value = response.opt("value");
        int statusCode = response.getInt("status");
        log.fine(String.format("Response from selendroid-server, status %d:\n%s", statusCode, value));
        log.fine("return status from selendroid android server: " + statusCode);
        return new SelendroidResponse(sessionId, StatusCode.fromInteger((Integer)statusCode), value);
    }

    private SelendroidResponse respondWithServerOnDeviceUnreachable(String sessionId, AndroidDevice device) throws JSONException {
        String message = "The selendroid server on the device became unreachable and there is no crash log from Android's uncaught exception handler. This can mean:\n- The test is trying to use a driver associated to a process that has finished (has the app been killed by the test?)\n- The app has been killed by the OS abruptly or there was a native crash (look at logcat)";
        try {
            String psOutput = device.listRunningThirdPartyProcesses();
            if (!Strings.isNullOrEmpty((String)psOutput)) {
                message = message + "\nCurrently running processes excluding system processes (via 'adb shell ps'):\n" + psOutput;
            }
        }
        catch (Exception e) {
            message = message + "\nCould not get list of running processes: " + e.getMessage();
        }
        return this.respondWithFailure(sessionId, (Exception)new SelendroidException(message));
    }

    private SelendroidResponse respondWithFailure(String sessionId, Exception e) throws JSONException {
        return new SelendroidResponse(sessionId, StatusCode.UNKNOWN_ERROR, (Throwable)e);
    }

    private JSONObject proxyRequestToDevice(HttpRequest request, ActiveSession session, String url, String method) throws Exception {
        HttpResponse r;
        if ("get".equalsIgnoreCase(method)) {
            log.fine("Proxy GET to the device: " + url);
            r = HttpClientUtil.executeRequest(url, HttpMethod.GET);
        } else if ("post".equalsIgnoreCase(method)) {
            JSONObject payload = this.getPayload(request);
            log.fine("Proxy POST to the device: " + url + ", payload:\n" + payload);
            r = HttpClientUtil.executeRequestWithPayload(url, session.getSelendroidServerPort(), HttpMethod.POST, payload.toString());
        } else if ("delete".equalsIgnoreCase(method)) {
            log.fine("Proxy DELETE to the device: " + url);
            r = HttpClientUtil.executeRequest(url, HttpMethod.DELETE);
        } else {
            throw new SelendroidException("HTTP method not supported: " + method);
        }
        return HttpClientUtil.parseJsonResponse(r);
    }
}

