/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model;

import io.selendroid.common.SelendroidCapabilities;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import io.selendroid.standalone.server.model.SessionTimeoutTask;
import java.util.Timer;
import java.util.TimerTask;

public class ActiveSession {
    private final String sessionId;
    private AndroidApp aut;
    private AndroidDevice device;
    private SelendroidCapabilities desiredCapabilities;
    private final int selendroidServerPort;
    private boolean invalid = false;
    private final Timer stopSessionTimer = new Timer(true);

    ActiveSession(String sessionId, SelendroidCapabilities desiredCapabilities, AndroidApp aut, AndroidDevice device, int selendroidPort, SelendroidStandaloneDriver driver) {
        this.selendroidServerPort = selendroidPort;
        this.sessionId = sessionId;
        this.aut = aut;
        this.device = device;
        this.desiredCapabilities = desiredCapabilities;
        this.stopSessionTimer.schedule((TimerTask)new SessionTimeoutTask(driver, sessionId), driver.getSelendroidConfiguration().getSessionTimeoutMillis());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActiveSession other = (ActiveSession)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    public AndroidApp getAut() {
        return this.aut;
    }

    public int getSelendroidServerPort() {
        return this.selendroidServerPort;
    }

    public SelendroidCapabilities getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public AndroidDevice getDevice() {
        return this.device;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public void stopSessionTimer() {
        this.stopSessionTimer.cancel();
    }

    public String toString() {
        return "ActiveSession [sessionId=" + this.sessionId + ", aut=" + this.aut + ", device=" + this.device + "]";
    }
}

