/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model;

import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.HardwareDeviceListener;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.exceptions.DeviceStoreException;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.model.DeviceStore;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHardwareDeviceListener
implements HardwareDeviceListener {
    private static final Logger log = Logger.getLogger(DefaultHardwareDeviceListener.class.getName());
    private DeviceStore store = null;
    private SelendroidStandaloneDriver driver;

    public DefaultHardwareDeviceListener(DeviceStore store, SelendroidStandaloneDriver driver) {
        this.store = store;
        this.driver = driver;
    }

    @Override
    public void onDeviceConnected(AndroidDevice device) {
        try {
            this.store.addDevice(device);
        }
        catch (AndroidDeviceException e) {
            log.log(Level.WARNING, "Could not add device to store", e);
        }
    }

    @Override
    public void onDeviceDisconnected(AndroidDevice device) {
        try {
            ActiveSession session = this.driver.findActiveSession(device);
            if (session != null) {
                session.invalidate();
            }
            this.store.removeAndroidDevice(device);
        }
        catch (DeviceStoreException e) {
            log.severe("The device cannot be removed: " + e.getMessage());
        }
    }

    @Override
    public void onDeviceChanged(AndroidDevice device) {
        try {
            this.store.updateDevice(device);
        }
        catch (AndroidDeviceException e) {
            log.log(Level.WARNING, "Could not update device.", e);
        }
    }
}

