/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.selendroid.common.SelendroidCapabilities;
import io.selendroid.common.device.DeviceTargetPlatform;
import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.AndroidEmulator;
import io.selendroid.standalone.android.AndroidEmulatorPowerStateListener;
import io.selendroid.standalone.android.DeviceManager;
import io.selendroid.standalone.android.HardwareDeviceListener;
import io.selendroid.standalone.android.impl.DefaultAndroidEmulator;
import io.selendroid.standalone.android.impl.DefaultHardwareDevice;
import io.selendroid.standalone.android.impl.InstalledAndroidApp;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.DeviceStoreException;
import io.selendroid.standalone.server.model.EmulatorPortFinder;
import io.selendroid.standalone.server.model.impl.DefaultPortFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DeviceStore {
    private static final Logger log = Logger.getLogger(DeviceStore.class.getName());
    private List<AndroidDevice> devicesInUse = new ArrayList<AndroidDevice>();
    private Map<DeviceTargetPlatform, List<AndroidDevice>> androidDevices = new HashMap<DeviceTargetPlatform, List<AndroidDevice>>();
    private EmulatorPortFinder androidEmulatorPortFinder = null;
    private boolean clearData = true;
    private boolean keepEmulator = false;
    private AndroidEmulatorPowerStateListener emulatorPowerStateListener = null;
    private DeviceManager deviceManager = null;

    public DeviceStore(Integer emulatorPort, DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.androidEmulatorPortFinder = new DefaultPortFinder(emulatorPort, emulatorPort + 30);
    }

    public DeviceStore(EmulatorPortFinder androidEmulatorPortFinder, DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.androidEmulatorPortFinder = androidEmulatorPortFinder;
    }

    public Integer nextEmulatorPort() {
        return this.androidEmulatorPortFinder.next();
    }

    public void release(AndroidDevice device, AndroidApp aut) {
        log.info("Releasing device " + device);
        if (this.devicesInUse.contains(device)) {
            if (aut != null) {
                try {
                    device.kill(aut);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to kill android application when releasing device", e);
                }
                if (this.clearData) {
                    try {
                        device.clearUserData(aut);
                    }
                    catch (AndroidSdkException e) {
                        log.log(Level.WARNING, "Failed to clear user data of application", e);
                    }
                }
            }
            if (device instanceof AndroidEmulator && !(aut instanceof InstalledAndroidApp) && !this.keepEmulator) {
                AndroidEmulator emulator = (AndroidEmulator)((Object)device);
                try {
                    emulator.stop();
                }
                catch (AndroidDeviceException e) {
                    log.severe("Failed to stop emulator: " + e.getMessage());
                }
                this.androidEmulatorPortFinder.release(emulator.getPort());
            }
            this.devicesInUse.remove(device);
        }
    }

    void initAndroidDevices(HardwareDeviceListener hardwareDeviceListener, boolean shouldKeepAdbAlive) throws AndroidDeviceException {
        this.emulatorPowerStateListener = new DefaultEmulatorPowerStateListener();
        this.deviceManager.initialize(hardwareDeviceListener, this.emulatorPowerStateListener);
        List<AndroidEmulator> emulators = DefaultAndroidEmulator.listAvailableAvds();
        this.addEmulators(emulators);
        if (this.getDevices().isEmpty()) {
            SelendroidException e = new SelendroidException("No android virtual devices were found. Please start the android tool and create emulators and restart the selendroid-standalone or plugin an Android hardware device via USB.");
            log.warning("Warning: " + e);
        }
    }

    public synchronized void addDevice(AndroidDevice androidDevice) throws AndroidDeviceException {
        if (androidDevice == null) {
            log.info("No Android devices were found.");
            return;
        }
        if (androidDevice instanceof AndroidEmulator) {
            throw new AndroidDeviceException("For adding emulator instances please use #addEmulator method.");
        }
        if (androidDevice.isDeviceReady()) {
            log.info("Adding: " + androidDevice);
            this.addDeviceToStore(androidDevice);
        }
    }

    public synchronized void updateDevice(AndroidDevice device) throws AndroidDeviceException {
        boolean deviceRemoved = false;
        for (DeviceTargetPlatform targetPlatform : this.androidDevices.keySet()) {
            List<AndroidDevice> platformDevices = this.androidDevices.get(targetPlatform);
            deviceRemoved |= platformDevices.remove(device);
        }
        if (deviceRemoved) {
            this.addDeviceToStore(device);
        } else {
            log.warning("Attempted to update device which did could not be found in the device store");
        }
    }

    public void addEmulators(List<AndroidEmulator> emulators) throws AndroidDeviceException {
        if (emulators == null || emulators.isEmpty()) {
            log.info("No emulators has been found.");
            return;
        }
        for (AndroidEmulator emulator : emulators) {
            log.info("Adding: " + emulator);
            this.addDeviceToStore((AndroidDevice)((Object)emulator));
        }
    }

    protected synchronized void addDeviceToStore(AndroidDevice device) throws AndroidDeviceException {
        if (this.androidDevices.containsKey(device.getTargetPlatform())) {
            List<AndroidDevice> platformDevices = this.androidDevices.get(device.getTargetPlatform());
            if (!platformDevices.contains(device)) {
                platformDevices.add(device);
            }
        } else {
            this.androidDevices.put(device.getTargetPlatform(), Lists.newArrayList((Object[])new AndroidDevice[]{device}));
        }
    }

    public synchronized AndroidDevice findAndroidDevice(SelendroidCapabilities caps) throws DeviceStoreException {
        Preconditions.checkArgument((caps != null ? 1 : 0) != 0, (Object)"Error: capabilities are null");
        if (this.androidDevices.isEmpty()) {
            throw new DeviceStoreException("Fatal Error: Device Store does not contain any Android Device.");
        }
        String platformVersion = caps.getPlatformVersion();
        Iterable candidateDevices = Strings.isNullOrEmpty((String)platformVersion) ? Iterables.concat(this.androidDevices.values()) : (Iterable)this.androidDevices.get(DeviceTargetPlatform.fromPlatformVersion((String)platformVersion));
        FluentIterable allMatchingDevices = FluentIterable.from((Iterable)(candidateDevices = (Iterable)Objects.firstNonNull((Object)candidateDevices, (Object)Collections.EMPTY_LIST))).filter(this.deviceNotInUse()).filter(this.deviceSatisfiesCapabilities(caps));
        if (!allMatchingDevices.isEmpty()) {
            AndroidDevice matchingDevice = (AndroidDevice)allMatchingDevices.filter(this.deviceRunning()).first().or(allMatchingDevices.first()).get();
            if (!this.deviceRunning().apply((Object)matchingDevice)) {
                log.info("Using potential match: " + matchingDevice);
            }
            this.devicesInUse.add(matchingDevice);
            return matchingDevice;
        }
        throw new DeviceStoreException("No devices are found. This can happen if the devices are in use or no device screen matches the required capabilities.");
    }

    private boolean isEmulatorSwitchedOff(AndroidDevice device) throws DeviceStoreException {
        if (device instanceof AndroidEmulator) {
            try {
                return !((AndroidEmulator)((Object)device)).isEmulatorStarted();
            }
            catch (AndroidDeviceException e) {
                throw new DeviceStoreException(e);
            }
        }
        return true;
    }

    public List<AndroidDevice> getDevices() {
        ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>();
        for (Map.Entry<DeviceTargetPlatform, List<AndroidDevice>> entry : this.androidDevices.entrySet()) {
            devices.addAll((Collection<AndroidDevice>)entry.getValue());
        }
        return devices;
    }

    List<AndroidDevice> getDevicesInUse() {
        return this.devicesInUse;
    }

    Map<DeviceTargetPlatform, List<AndroidDevice>> getDevicesList() {
        return this.androidDevices;
    }

    public void removeAndroidDevice(AndroidDevice device) throws DeviceStoreException {
        if (device == null) {
            return;
        }
        boolean hardwareDevice = device instanceof DefaultHardwareDevice;
        if (!hardwareDevice) {
            throw new DeviceStoreException("Only devices of type 'DefaultHardwareDevice' can be removed.");
        }
        this.release(device, null);
        DeviceTargetPlatform apiLevel = device.getTargetPlatform();
        if (this.androidDevices.containsKey(apiLevel)) {
            log.info("Removing: " + device);
            this.androidDevices.get(apiLevel).remove(device);
            if (this.androidDevices.get(apiLevel).isEmpty()) {
                this.androidDevices.remove(apiLevel);
            }
        } else {
            for (List<AndroidDevice> targetDevices : this.androidDevices.values()) {
                if (!targetDevices.contains(device)) continue;
                log.warning("Device in devicestore");
            }
            log.warning("The target platform version of the device is not found in device store.");
            log.warning("The device was propably already removed.");
        }
    }

    public void setClearData(boolean clearData) {
        this.clearData = clearData;
    }

    public void setKeepEmulator(boolean keepEmulator) {
        this.keepEmulator = keepEmulator;
    }

    private Predicate<AndroidDevice> deviceNotInUse() {
        return new Predicate<AndroidDevice>(){

            public boolean apply(AndroidDevice candidate) {
                return !DeviceStore.this.devicesInUse.contains(candidate);
            }
        };
    }

    private Predicate<AndroidDevice> deviceSatisfiesCapabilities(final SelendroidCapabilities capabilities) {
        return new Predicate<AndroidDevice>(){

            public boolean apply(AndroidDevice candidate) {
                ArrayList booleanExpressions = Lists.newArrayList((Object[])new Boolean[]{candidate.screenSizeMatches(capabilities.getScreenSize()), capabilities.getEmulator() == null ? true : (capabilities.getEmulator() != false ? candidate instanceof DefaultAndroidEmulator : candidate instanceof DefaultHardwareDevice), StringUtils.isNotBlank((CharSequence)capabilities.getSerial()) ? capabilities.getSerial().equals(candidate.getSerial()) : true, StringUtils.isNotBlank((CharSequence)capabilities.getModel()) ? candidate.getModel().contains(capabilities.getModel()) : true});
                return Iterables.all((Iterable)booleanExpressions, (Predicate)Predicates.equalTo((Object)true));
            }
        };
    }

    private Predicate<AndroidDevice> deviceRunning() {
        return new Predicate<AndroidDevice>(){

            public boolean apply(AndroidDevice candidate) {
                return !(candidate instanceof DefaultAndroidEmulator) || ((DefaultAndroidEmulator)candidate).isEmulatorStarted();
            }
        };
    }

    class DefaultEmulatorPowerStateListener
    implements AndroidEmulatorPowerStateListener {
        DefaultEmulatorPowerStateListener() {
        }

        @Override
        public void onDeviceStarted(String avdName, String serial) {
            AndroidEmulator emulator = this.findEmulator(avdName);
            if (emulator != null) {
                Integer port = Integer.parseInt(serial.replace("emulator-", ""));
                emulator.setSerial(port);
                emulator.setWasStartedBySelendroid(false);
            }
        }

        AndroidEmulator findEmulator(String avdName) {
            for (AndroidDevice device : DeviceStore.this.getDevices()) {
                AndroidEmulator emulator;
                if (!(device instanceof AndroidEmulator) || !avdName.equals((emulator = (AndroidEmulator)((Object)device)).getAvdName())) continue;
                return emulator;
            }
            return null;
        }

        @Override
        public void onDeviceStopped(String avdName) {
        }
    }
}

