/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import io.netty.handler.codec.http.HttpMethod;
import io.selendroid.common.SelendroidCapabilities;
import io.selendroid.server.common.ServerDetails;
import io.selendroid.server.common.exceptions.AppCrashedException;
import io.selendroid.server.common.exceptions.SelendroidException;
import io.selendroid.server.common.exceptions.SessionNotCreatedException;
import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.android.AndroidApp;
import io.selendroid.standalone.android.AndroidDevice;
import io.selendroid.standalone.android.AndroidEmulator;
import io.selendroid.standalone.android.AndroidSdk;
import io.selendroid.standalone.android.DeviceManager;
import io.selendroid.standalone.android.impl.DefaultAndroidEmulator;
import io.selendroid.standalone.android.impl.DefaultDeviceManager;
import io.selendroid.standalone.android.impl.DefaultHardwareDevice;
import io.selendroid.standalone.android.impl.InstalledAndroidApp;
import io.selendroid.standalone.builder.AndroidDriverAPKBuilder;
import io.selendroid.standalone.builder.SelendroidServerBuilder;
import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.exceptions.ShellCommandException;
import io.selendroid.standalone.server.model.ActiveSession;
import io.selendroid.standalone.server.model.DefaultHardwareDeviceListener;
import io.selendroid.standalone.server.model.DeviceStore;
import io.selendroid.standalone.server.model.DummySelendroidStandaloneDriverEventListener;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriverEventListener;
import io.selendroid.standalone.server.util.FolderMonitor;
import io.selendroid.standalone.server.util.HttpClientUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SelendroidStandaloneDriver
implements ServerDetails {
    public static final String WD_RESP_KEY_VALUE = "value";
    public static final String WD_RESP_KEY_STATUS = "status";
    public static final String WD_RESP_KEY_SESSION_ID = "sessionId";
    public static final String APP_BASE_PACKAGE = "basePackage";
    public static final String APP_ID = "appId";
    private static int selendroidServerPort = 38080;
    private static final Logger log = Logger.getLogger(SelendroidStandaloneDriver.class.getName());
    private Map<String, AndroidApp> appsStore = new HashMap<String, AndroidApp>();
    private Map<String, AndroidApp> selendroidServers = new HashMap<String, AndroidApp>();
    private Map<String, ActiveSession> sessions = new HashMap<String, ActiveSession>();
    private DeviceStore deviceStore = null;
    private SelendroidServerBuilder selendroidApkBuilder = null;
    private AndroidDriverAPKBuilder androidDriverAPKBuilder = null;
    private SelendroidConfiguration serverConfiguration = null;
    private DeviceManager deviceManager;
    private FolderMonitor folderMonitor = null;
    private SelendroidStandaloneDriverEventListener eventListener = new DummySelendroidStandaloneDriverEventListener();

    public SelendroidStandaloneDriver(SelendroidConfiguration serverConfiguration) throws AndroidSdkException, AndroidDeviceException {
        this.serverConfiguration = serverConfiguration;
        this.selendroidApkBuilder = new SelendroidServerBuilder(serverConfiguration);
        this.androidDriverAPKBuilder = new AndroidDriverAPKBuilder();
        selendroidServerPort = serverConfiguration.getSelendroidServerPort();
        if (serverConfiguration.getAppFolderToMonitor() != null) {
            this.startFolderMonitor();
        }
        this.initApplicationsUnderTest(serverConfiguration);
        this.initAndroidDevices();
        this.deviceStore.setClearData(!serverConfiguration.isNoClearData());
        this.deviceStore.setKeepEmulator(serverConfiguration.isKeepEmulator());
    }

    SelendroidStandaloneDriver(SelendroidServerBuilder builder, DeviceManager deviceManager, AndroidDriverAPKBuilder androidDriverAPKBuilder) {
        this.selendroidApkBuilder = builder;
        this.deviceManager = deviceManager;
        this.androidDriverAPKBuilder = androidDriverAPKBuilder;
    }

    public void addToAppsStore(File file) throws AndroidSdkException {
        AndroidApp app = null;
        try {
            app = this.selendroidApkBuilder.resignApp(file);
        }
        catch (ShellCommandException e) {
            throw new SessionNotCreatedException("An error occurred while resigning the app '" + file.getName() + "'. ", (Throwable)e);
        }
        String appId = null;
        try {
            appId = app.getAppId();
        }
        catch (AndroidSdkException e) {
            log.info("Ignoring app because an error occurred reading the app details: " + file.getAbsolutePath());
            log.info(e.getMessage());
        }
        if (appId != null && !this.appsStore.containsKey(appId)) {
            this.appsStore.put(appId, app);
            log.info("App " + appId + " has been added to selendroid standalone server.");
        }
    }

    void initApplicationsUnderTest(SelendroidConfiguration serverConfiguration) throws AndroidSdkException {
        if (serverConfiguration == null) {
            throw new SelendroidException("Configuration error - serverConfiguration can't be null.");
        }
        this.serverConfiguration = serverConfiguration;
        for (String appPath : serverConfiguration.getSupportedApps()) {
            File file = new File(appPath);
            if (file.exists()) {
                this.addToAppsStore(file);
                continue;
            }
            log.severe("Ignoring app because it was not found: " + file.getAbsolutePath());
        }
        if (!serverConfiguration.isNoWebViewApp()) {
            try {
                AndroidApp app = this.selendroidApkBuilder.resignApp(this.androidDriverAPKBuilder.extractAndroidDriverAPK());
                this.appsStore.put("android", app);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void initAndroidDevices() throws AndroidDeviceException {
        this.deviceManager = new DefaultDeviceManager(AndroidSdk.adb().getAbsolutePath(), this.serverConfiguration.shouldKeepAdbAlive());
        this.deviceStore = new DeviceStore(this.serverConfiguration.getEmulatorPort(), this.deviceManager);
        this.deviceStore.initAndroidDevices(new DefaultHardwareDeviceListener(this.deviceStore, this), this.serverConfiguration.shouldKeepAdbAlive());
    }

    public String getServerVersion() {
        return SelendroidServerBuilder.getJarVersionNumber();
    }

    public String getCpuArch() {
        return System.getProperty("os.arch");
    }

    public String getOsVersion() {
        return System.getProperty("os.version");
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    protected SelendroidConfiguration getSelendroidConfiguration() {
        return this.serverConfiguration;
    }

    public String createNewTestSession(JSONObject caps) {
        return this.createNewTestSession(caps, this.serverConfiguration.getServerStartRetries());
    }

    public String createNewTestSession(JSONObject caps, Integer retries) {
        AndroidDevice device = null;
        AndroidApp app = null;
        Exception lastException = null;
        while (retries >= 0) {
            try {
                boolean appInstalledOnDevice;
                SelendroidCapabilities desiredCapabilities = this.getSelendroidCapabilities(caps);
                String desiredAut = desiredCapabilities.getDefaultApp(this.appsStore.keySet());
                app = this.getAndroidApp(desiredCapabilities, desiredAut);
                log.info("'" + desiredAut + "' will be used as app under test.");
                device = this.deviceStore.findAndroidDevice(desiredCapabilities);
                if (device instanceof AndroidEmulator) {
                    this.startAndroidEmulator(desiredCapabilities, (AndroidEmulator)((Object)device));
                }
                boolean bl = appInstalledOnDevice = device.isInstalled(app) || app instanceof InstalledAndroidApp;
                if (!appInstalledOnDevice || this.serverConfiguration.isForceReinstall()) {
                    device.install(app);
                } else {
                    log.info("the app under test is already installed.");
                }
                int port = this.getNextSelendroidServerPort();
                boolean serverInstalled = device.isInstalled("io.selendroid." + app.getBasePackage());
                if (!serverInstalled || this.serverConfiguration.isForceReinstall()) {
                    try {
                        device.install(this.createSelendroidServerApk(app));
                    }
                    catch (AndroidSdkException e) {
                        throw new SessionNotCreatedException("Could not install selendroid-server on the device", (Throwable)e);
                    }
                } else {
                    log.info("Not creating and installing selendroid-server because it is already installed for this app under test.");
                }
                List preSessionAdbCommands = desiredCapabilities.getPreSessionAdbCommands();
                this.runPreSessionCommands(device, preSessionAdbCommands);
                String extensionFile = desiredCapabilities.getSelendroidExtensions();
                this.pushExtensionsToDevice(device, extensionFile);
                device.setLoggingEnabled(this.serverConfiguration.isDeviceLog());
                this.eventListener.onBeforeDeviceServerStart();
                device.startSelendroid(app, port, desiredCapabilities);
                this.waitForServerStart(device);
                this.eventListener.onAfterDeviceServerStart();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                RemoteWebDriver driver = new RemoteWebDriver(new URL("http://localhost:" + port + "/wd/hub"), (Capabilities)desiredCapabilities);
                String sessionId = driver.getSessionId().toString();
                SelendroidCapabilities requiredCapabilities = new SelendroidCapabilities(driver.getCapabilities().asMap());
                ActiveSession session = new ActiveSession(sessionId, requiredCapabilities, app, device, port, this);
                this.sessions.put(sessionId, session);
                if ("android".equals(desiredCapabilities.getAut())) {
                    this.switchToWebView(driver);
                }
                return sessionId;
            }
            catch (Exception e) {
                lastException = e;
                log.log(Level.SEVERE, "Error occurred while starting Selendroid session", e);
                Integer n = retries;
                Integer n2 = retries = Integer.valueOf(retries - 1);
                if (device == null) continue;
                this.deviceStore.release(device, app);
                device = null;
            }
        }
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw new SessionNotCreatedException("Error starting Selendroid session", (Throwable)lastException);
    }

    private void switchToWebView(RemoteWebDriver driver) {
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 60L);
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.className((String)"android.webkit.WebView")));
        driver.switchTo().window("WEBVIEW");
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"AndroidDriver")));
    }

    private void waitForServerStart(AndroidDevice device) {
        long startTimeout = this.serverConfiguration.getServerStartTimeout();
        long timeoutEnd = System.currentTimeMillis() + startTimeout;
        while (!device.isSelendroidRunning()) {
            if (timeoutEnd >= System.currentTimeMillis()) {
                try {
                    Thread.sleep(2000L);
                    String crashMessage = device.getCrashLog();
                    if (crashMessage.isEmpty()) continue;
                    throw new AppCrashedException(crashMessage);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            throw new SelendroidException("Selendroid server on the device didn't come up after " + startTimeout / 1000L + "sec:");
        }
    }

    private void pushExtensionsToDevice(AndroidDevice device, String extensionFile) {
        if (extensionFile != null) {
            String externalStorageDirectory = device.getExternalStoragePath();
            String deviceDexPath = new File(externalStorageDirectory, "extension.dex").getAbsolutePath();
            device.runAdbCommand(String.format("push %s %s", extensionFile, deviceDexPath));
        }
    }

    private void runPreSessionCommands(AndroidDevice device, List<String> preSessionAdbCommands) {
        ArrayList<String> adbCommands = new ArrayList<String>();
        adbCommands.add("shell setprop log.tag.SELENDROID " + this.serverConfiguration.getLogLevel().name());
        adbCommands.addAll(preSessionAdbCommands);
        for (String adbCommandParameter : adbCommands) {
            device.runAdbCommand(adbCommandParameter);
        }
    }

    private void startAndroidEmulator(SelendroidCapabilities desiredCapabilities, AndroidEmulator device) throws AndroidDeviceException {
        AndroidEmulator emulator = device;
        if (emulator.isEmulatorStarted()) {
            emulator.unlockEmulatorScreen();
        } else {
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (this.serverConfiguration.getEmulatorOptions() != null) {
                config.put("OPTIONS", this.serverConfiguration.getEmulatorOptions());
            }
            config.put("TIMEOUT", this.serverConfiguration.getTimeoutEmulatorStart());
            if (desiredCapabilities.asMap().containsKey("display")) {
                Object d = desiredCapabilities.getCapability("display");
                config.put("DISPLAY", String.valueOf(d));
            }
            Locale locale = this.parseLocale(desiredCapabilities);
            emulator.start(locale, this.deviceStore.nextEmulatorPort(), config);
        }
        emulator.setIDevice(this.deviceManager.getVirtualDevice(emulator.getAvdName()));
    }

    private AndroidApp getAndroidApp(SelendroidCapabilities desiredCapabilities, String aut) {
        AndroidApp app = this.appsStore.get(aut);
        if (app == null) {
            if (desiredCapabilities.getLaunchActivity() != null) {
                String appInfo = String.format("%s/%s", aut, desiredCapabilities.getLaunchActivity());
                log.log(Level.INFO, "The requested application under test is not configured in selendroid server, assuming the " + appInfo + " is installed on the device.");
                app = new InstalledAndroidApp(appInfo);
            } else {
                throw new SessionNotCreatedException("The requested application under test is not configured in selendroid server.");
            }
        }
        app = this.augmentApp(app, desiredCapabilities);
        return app;
    }

    private SelendroidCapabilities getSelendroidCapabilities(JSONObject caps) {
        SelendroidCapabilities desiredCapabilities;
        try {
            desiredCapabilities = new SelendroidCapabilities(caps);
        }
        catch (JSONException e) {
            throw new SelendroidException("Desired capabilities cannot be parsed.");
        }
        return desiredCapabilities;
    }

    private AndroidApp augmentApp(AndroidApp app, SelendroidCapabilities desiredCapabilities) {
        if (desiredCapabilities.getLaunchActivity() != null) {
            app.setMainActivity(desiredCapabilities.getLaunchActivity());
        }
        return app;
    }

    private AndroidApp createSelendroidServerApk(AndroidApp aut) throws AndroidSdkException {
        if (!this.selendroidServers.containsKey(aut.getAppId())) {
            try {
                AndroidApp selendroidServer = this.selendroidApkBuilder.createSelendroidServer(aut);
                this.selendroidServers.put(aut.getAppId(), selendroidServer);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot build the Selendroid server APK", e);
                throw new SessionNotCreatedException("Cannot build the Selendroid server APK for application '" + aut + "': " + e.getMessage());
            }
        }
        return this.selendroidServers.get(aut.getAppId());
    }

    private Locale parseLocale(SelendroidCapabilities capa) {
        if (capa.getLocale() == null) {
            return null;
        }
        String[] localeStr = capa.getLocale().split("_");
        return new Locale(localeStr[0], localeStr[1]);
    }

    private void startFolderMonitor() {
        if (this.serverConfiguration.getAppFolderToMonitor() != null) {
            try {
                this.folderMonitor = new FolderMonitor(this, this.serverConfiguration);
                this.folderMonitor.start();
            }
            catch (IOException e) {
                log.warning("Could not monitor the given folder: " + this.serverConfiguration.getAppFolderToMonitor());
            }
        }
    }

    Map<String, AndroidApp> getConfiguredApps() {
        return Collections.unmodifiableMap(this.appsStore);
    }

    void setDeviceStore(DeviceStore store) {
        this.deviceStore = store;
    }

    private synchronized int getNextSelendroidServerPort() {
        return selendroidServerPort++;
    }

    public List<ActiveSession> getActiveSessions() {
        return Lists.newArrayList(this.sessions.values());
    }

    public boolean isValidSession(String sessionId) {
        return sessionId != null && !sessionId.isEmpty() && this.sessions.containsKey(sessionId);
    }

    public void stopSession(String sessionId) throws AndroidDeviceException {
        if (this.isValidSession(sessionId)) {
            ActiveSession session = this.sessions.get(sessionId);
            session.stopSessionTimer();
            try {
                HttpClientUtil.executeRequest("http://localhost:" + session.getSelendroidServerPort() + "/wd/hub/session/" + sessionId, HttpMethod.DELETE);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error stopping session, safe to ignore", e);
            }
            this.deviceStore.release(session.getDevice(), session.getAut());
            this.sessions.remove(sessionId);
        }
    }

    public void quitSelendroid() {
        List sessionsToQuit = Lists.newArrayList(this.sessions.keySet());
        if (!sessionsToQuit.isEmpty()) {
            for (String sessionId : sessionsToQuit) {
                try {
                    this.stopSession(sessionId);
                }
                catch (AndroidDeviceException e) {
                    log.log(Level.SEVERE, "Error occurred while stopping session", e);
                }
            }
        }
        this.deviceManager.shutdown();
    }

    public SelendroidCapabilities getSessionCapabilities(String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId).getDesiredCapabilities();
        }
        return null;
    }

    public ActiveSession getActiveSession(String sessionId) {
        if (sessionId != null && this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId);
        }
        return null;
    }

    public synchronized JSONArray getSupportedApps() {
        JSONArray list = new JSONArray();
        for (AndroidApp app : this.appsStore.values()) {
            JSONObject appInfo = new JSONObject();
            try {
                appInfo.put(APP_ID, (Object)app.getAppId());
                appInfo.put(APP_BASE_PACKAGE, (Object)app.getBasePackage());
                appInfo.put("mainActivity", (Object)app.getMainActivity());
                list.put((Object)appInfo);
            }
            catch (Exception e) {}
        }
        return list;
    }

    public synchronized JSONArray getSupportedDevices() {
        JSONArray list = new JSONArray();
        for (AndroidDevice device : this.deviceStore.getDevices()) {
            JSONObject deviceInfo = new JSONObject();
            try {
                if (device instanceof DefaultAndroidEmulator) {
                    deviceInfo.put("emulator", true);
                    deviceInfo.put("avdName", (Object)((DefaultAndroidEmulator)device).getAvdName());
                } else {
                    deviceInfo.put("emulator", false);
                    deviceInfo.put("model", (Object)((DefaultHardwareDevice)device).getModel());
                    deviceInfo.put("serial", (Object)((DefaultHardwareDevice)device).getSerial());
                }
                deviceInfo.put("platformVersion", (Object)device.getTargetPlatform().getApi());
                deviceInfo.put("screenSize", (Object)device.getScreenSize());
                list.put((Object)deviceInfo);
            }
            catch (Exception e) {
                log.info("Error occurred when building supported device info: " + e.getMessage());
            }
        }
        return list;
    }

    protected ActiveSession findActiveSession(AndroidDevice device) {
        for (ActiveSession session : this.sessions.values()) {
            if (!session.getDevice().equals(device)) continue;
            return session;
        }
        return null;
    }

    public byte[] takeScreenshot(String sessionId) throws AndroidDeviceException {
        if (sessionId == null || !this.sessions.containsKey(sessionId)) {
            throw new SelendroidException("The given session id '" + sessionId + "' was not found.");
        }
        return this.sessions.get(sessionId).getDevice().takeScreenshot();
    }

    public void setEventListener(SelendroidStandaloneDriverEventListener eventListener) {
        this.eventListener = eventListener;
    }
}

