/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model;

import io.selendroid.standalone.exceptions.AndroidDeviceException;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.util.TimerTask;
import java.util.logging.Logger;

public class SessionTimeoutTask
extends TimerTask {
    private static final Logger log = Logger.getLogger(SessionTimeoutTask.class.getName());
    private String sessionId;
    private SelendroidStandaloneDriver driver;

    public SessionTimeoutTask(SelendroidStandaloneDriver driver, String sessionId) {
        this.sessionId = sessionId;
        this.driver = driver;
    }

    @Override
    public void run() {
        int sessionTimeout = this.driver.getSelendroidConfiguration().getSessionTimeoutMillis();
        log.info("Stopping session after configured session timeout of " + sessionTimeout / 1000 + " seconds.");
        try {
            this.driver.stopSession(this.sessionId);
        }
        catch (AndroidDeviceException e) {
            log.severe("While closing the session " + this.sessionId + " after a session time out an error occurred: " + e.getMessage());
        }
    }
}

